/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.nervousync.database.enumerations.join.JoinType;
import org.nervousync.database.enumerations.lock.LockOption;
import org.nervousync.database.exceptions.entity.EntityStatusException;
import org.nervousync.database.exceptions.record.QueryException;
import org.nervousync.database.query.condition.MatchCondition;
import org.nervousync.database.query.condition.QueryCondition;
import org.nervousync.database.query.core.QueryItem;
import org.nervousync.database.query.core.QueryTable;
import org.nervousync.database.query.group.GroupByColumn;
import org.nervousync.database.query.operate.ConditionCode;
import org.nervousync.database.query.operate.ConnectionCode;
import org.nervousync.database.query.orderby.OrderByColumn;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.SecurityUtils;

public final class QueryInfo {
    private final QueryTable queryTable;
    private final List<OrderByColumn> orderByColumns;
    private final List<GroupByColumn> groupByColumns;
    private final int pageLimit;
    private final int offset;
    private final boolean cacheables;
    private final boolean forUpdate;
    private final LockOption lockOption;
    private final boolean analyzed;

    private QueryInfo(QueryTable queryTable, List<OrderByColumn> orderByColumns, List<GroupByColumn> groupByColumns, int pageLimit, int offset, boolean cacheables, boolean forUpdate, LockOption lockOption, boolean analyzed) {
        this.queryTable = queryTable;
        this.orderByColumns = orderByColumns;
        this.groupByColumns = groupByColumns;
        this.pageLimit = pageLimit;
        this.offset = offset;
        this.cacheables = cacheables;
        this.forUpdate = forUpdate;
        this.lockOption = lockOption;
        this.analyzed = analyzed;
    }

    public QueryTable getQueryTable() {
        return this.queryTable;
    }

    public List<OrderByColumn> getOrderByColumns() {
        return this.orderByColumns;
    }

    public List<GroupByColumn> getGroupByColumns() {
        return this.groupByColumns;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isCacheables() {
        return this.cacheables;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public LockOption getLockOption() {
        return this.lockOption;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public boolean pagerQuery() {
        return this.offset != -1 && this.pageLimit != -1;
    }

    public String cacheKey() {
        if (this.forUpdate || !this.cacheables) {
            return "";
        }
        TreeMap<String, Object> queryMap = new TreeMap<String, Object>();
        queryMap.put("QueryTable", this.queryTable.cacheKey());
        HashMap orderByMap = new HashMap();
        this.orderByColumns.forEach(orderByColumn -> orderByMap.put(orderByColumn.cacheKey(), orderByColumn.orderByType().toString()));
        queryMap.put("OrderBy", orderByMap);
        HashMap groupByMap = new HashMap();
        this.groupByColumns.forEach(groupByColumn -> groupByMap.put(groupByColumn.entityClass(), groupByColumn.identifyKey()));
        queryMap.put("GroupBy", groupByMap);
        queryMap.put("PageLimit", this.pageLimit);
        queryMap.put("Offset", this.offset);
        return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(queryMap));
    }

    public static Builder newBuilder(Class<?> entityClass) {
        return new Builder("", entityClass, Boolean.FALSE);
    }

    public static Builder newBuilder(String aliasName, Class<?> entityClass) {
        return new Builder(aliasName, entityClass, Boolean.FALSE);
    }

    public static Builder analyzeBuilder(String aliasName, Class<?> entityClass) {
        return new Builder(aliasName, entityClass, Boolean.TRUE);
    }

    private static int queryOffset(int pageNo, int pageLimit) {
        int currentPage = pageNo <= 0 ? 1 : pageNo;
        return (currentPage - 1) * QueryInfo.queryLimit(pageLimit);
    }

    private static int queryLimit(int pageLimit) {
        return pageLimit <= 0 ? 20 : pageLimit;
    }

    public static final class Builder {
        private final QueryTable.QueryBuilder queryBuilder;
        private final List<OrderByColumn> orderByColumns;
        private final List<GroupByColumn> groupByColumns;
        private int pageLimit = -1;
        private int offset = 0;
        private boolean cacheables = Boolean.FALSE;
        private boolean forUpdate = Boolean.FALSE;
        private LockOption lockOption = LockOption.NONE;
        private final boolean analyzed;

        private Builder(String aliasName, Class<?> entityClass, boolean analyzed) {
            this.queryBuilder = QueryTable.newBuilder(aliasName, entityClass, 0);
            this.orderByColumns = new ArrayList<OrderByColumn>();
            this.groupByColumns = new ArrayList<GroupByColumn>();
            this.analyzed = analyzed;
        }

        public void joinTable(JoinType joinType, String aliasName, Class<?> entityClass, Class<?> referenceClass) throws EntityStatusException {
            if (this.analyzed && !this.queryBuilder.analyzeCheck(entityClass, referenceClass)) {
                throw new EntityStatusException("Analyze check failed! ");
            }
            this.queryBuilder.joinTable(joinType, aliasName, entityClass, referenceClass);
        }

        public void queryColumn(Class<?> entityClass, String identifyKey) {
            this.queryColumn(entityClass, identifyKey, Boolean.FALSE);
        }

        public void queryColumn(Class<?> entityClass, String identifyKey, boolean distinct) {
            this.queryColumn(entityClass, identifyKey, distinct, "");
        }

        public void queryColumn(Class<?> entityClass, String identifyKey, boolean distinct, String aliasName) {
            this.queryBuilder.addQueryColumn(entityClass, identifyKey, distinct, aliasName);
        }

        public void queryFunction(Class<?> entityClass, String aliasName, String sqlFunction, QueryItem ... functionParams) {
            this.queryBuilder.addQueryFunction(entityClass, aliasName, sqlFunction, functionParams);
        }

        public void greater(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.greater(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void greater(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.GREATER, entityClass, identifyKey, matchCondition);
        }

        public void greaterEqual(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.greaterEqual(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void greaterEqual(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.GREATER_EQUAL, entityClass, identifyKey, matchCondition);
        }

        public void less(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.less(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void less(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.LESS, entityClass, identifyKey, matchCondition);
        }

        public void lessEqual(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.lessEqual(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void lessEqual(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.LESS_EQUAL, entityClass, identifyKey, matchCondition);
        }

        public void equal(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.equal(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void equal(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.EQUAL, entityClass, identifyKey, matchCondition);
        }

        public void notEqual(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.notEqual(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void notEqual(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.NOT_EQUAL, entityClass, identifyKey, matchCondition);
        }

        public void betweenAnd(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.betweenAnd(ConnectionCode.AND, identifyKey, entityClass, matchCondition);
        }

        public void betweenAnd(ConnectionCode connCode, String identifyKey, Class<?> entityClass, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.BETWEEN_AND, entityClass, identifyKey, matchCondition);
        }

        public void notBetweenAnd(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.notBetweenAnd(ConnectionCode.AND, identifyKey, entityClass, matchCondition);
        }

        public void notBetweenAnd(ConnectionCode connCode, String identifyKey, Class<?> entityClass, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.NOT_BETWEEN_AND, entityClass, identifyKey, matchCondition);
        }

        public void like(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.like(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void like(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.LIKE, entityClass, identifyKey, matchCondition);
        }

        public void notLike(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.notLike(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void notLike(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.NOT_LIKE, entityClass, identifyKey, matchCondition);
        }

        public void isNull(Class<?> entityClass, String identifyKey) {
            this.isNull(ConnectionCode.AND, entityClass, identifyKey);
        }

        public void isNull(ConnectionCode connCode, Class<?> entityClass, String identifyKey) {
            this.add(connCode, ConditionCode.IS_NULL, entityClass, identifyKey, null);
        }

        public void notNull(Class<?> entityClass, String identifyKey) {
            this.notNull(ConnectionCode.AND, entityClass, identifyKey);
        }

        public void notNull(ConnectionCode connCode, Class<?> entityClass, String identifyKey) {
            this.add(connCode, ConditionCode.NOT_NULL, entityClass, identifyKey, null);
        }

        public void in(Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.in(ConnectionCode.AND, entityClass, identifyKey, matchCondition);
        }

        public void in(ConnectionCode connCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.add(connCode, ConditionCode.IN, entityClass, identifyKey, matchCondition);
        }

        public void group(QueryCondition ... queryConditions) {
            this.group(ConnectionCode.AND, queryConditions);
        }

        public void group(ConnectionCode connCode, QueryCondition ... queryConditions) {
            this.add(connCode, ConditionCode.GROUP, null, "", MatchCondition.group(queryConditions));
        }

        private void add(ConnectionCode connCode, ConditionCode conditionCode, Class<?> entityClass, String identifyKey, MatchCondition matchCondition) {
            this.queryBuilder.addQueryCondition(entityClass, connCode, conditionCode, identifyKey, matchCondition);
        }

        public void orderByItem(Class<?> entityClass, String columnName) {
            this.orderByItem(entityClass, columnName, OrderByColumn.OrderByType.ASC);
        }

        public void orderByItem(Class<?> entityClass, String identifyName, OrderByColumn.OrderByType orderByType) throws QueryException {
            if (this.queryBuilder.contains(entityClass)) {
                this.orderByColumns.add(new OrderByColumn(orderByType, entityClass, identifyName));
            }
        }

        public void groupByItem(Class<?> entityClass, String identifyName) throws QueryException {
            if (this.queryBuilder.contains(entityClass)) {
                this.groupByColumns.add(new GroupByColumn(entityClass, identifyName));
            }
        }

        public void useCache(boolean cacheables) {
            this.cacheables = cacheables;
        }

        public void configPager(int pageNo, int pageLimit) {
            this.pageLimit = QueryInfo.queryLimit(pageLimit);
            this.offset = QueryInfo.queryOffset(pageNo, this.pageLimit);
        }

        public void pagerParameter(int offset, int pageLimit) {
            this.offset = offset < 0 ? 0 : offset;
            this.pageLimit = QueryInfo.queryLimit(pageLimit);
        }

        public void forUpdate(boolean forUpdate) {
            this.forUpdate = forUpdate;
        }

        public void lockOption(LockOption lockOption) {
            this.lockOption = this.forUpdate ? lockOption : LockOption.NONE;
        }

        public boolean analyzeBuilder() {
            return this.analyzed;
        }

        public boolean match(String databaseName) {
            return this.queryBuilder.match(databaseName);
        }

        public QueryInfo build() {
            return new QueryInfo(this.queryBuilder.build(), this.orderByColumns, this.groupByColumns, this.pageLimit, this.offset, this.cacheables, this.forUpdate, this.lockOption, this.analyzed);
        }
    }
}

