/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nervousync.database.commons.DatabaseCommons;
import org.nervousync.database.exceptions.entity.EntityStatusException;
import org.nervousync.database.exceptions.security.DataModifiedException;
import org.nervousync.database.query.result.ResultMap;
import org.nervousync.utils.StringUtils;

public final class PartialCollection
implements Serializable {
    private static final long serialVersionUID = 2086690645677391624L;
    private static final String TOTAL_COUNT_KEY = "totalCount";
    private static final String RESULT_LIST_KEY = "objectList";
    private final List<ResultMap> resultList;
    private final long totalCount;

    public PartialCollection(List<ResultMap> resultList, long totalCount) {
        this.resultList = resultList;
        this.totalCount = totalCount;
    }

    public List<ResultMap> asList() {
        return this.resultList;
    }

    public <T> List<T> asList(Class<T> clazz) {
        return this.asList(clazz, Boolean.FALSE, -1L);
    }

    public <T> List<T> asList(Class<T> clazz, boolean forUpdate, long transactionalCode) throws DataModifiedException, EntityStatusException {
        ArrayList returnList = new ArrayList();
        if (ResultMap.class.equals(clazz)) {
            this.resultList.forEach(resultMap -> returnList.add(clazz.cast(resultMap)));
        } else {
            this.resultList.forEach(resultMap -> returnList.add(resultMap.unwrap(clazz, forUpdate, -1L, transactionalCode)));
        }
        return returnList;
    }

    public int size() {
        return this.resultList.size();
    }

    public boolean isEmpty() {
        return this.resultList.isEmpty();
    }

    public boolean add(ResultMap resultMap) {
        return this.resultList.add(resultMap);
    }

    public Iterator<ResultMap> iterator() {
        return this.resultList.iterator();
    }

    public <T> Iterator<T> iterator(Class<T> clazz, boolean forUpdate, long transactionalCode) {
        return this.asList(clazz, forUpdate, transactionalCode).iterator();
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public static PartialCollection parse(String cacheData) {
        if (StringUtils.isEmpty((CharSequence)cacheData)) {
            return null;
        }
        Map convertMap = StringUtils.dataToMap((String)cacheData, (StringUtils.StringType)StringUtils.StringType.JSON);
        if (convertMap.isEmpty()) {
            return null;
        }
        long totalCount = Long.parseLong((String)convertMap.get(TOTAL_COUNT_KEY), 16);
        List dataList = StringUtils.stringToList((String)((String)convertMap.get(RESULT_LIST_KEY)), (String)"UTF-8", String.class);
        ArrayList<ResultMap> objectList = new ArrayList<ResultMap>();
        dataList.forEach(dataInfo -> objectList.add(new ResultMap(DatabaseCommons.cacheDataToMap(dataInfo))));
        return new PartialCollection(objectList, totalCount);
    }

    public String cacheData() {
        ArrayList<String> objectList = new ArrayList<String>(this.resultList.size());
        for (ResultMap object : this.resultList) {
            objectList.add(object.cacheData());
        }
        HashMap<String, String> convertMap = new HashMap<String, String>();
        convertMap.put(TOTAL_COUNT_KEY, Long.toHexString(this.totalCount));
        convertMap.put(RESULT_LIST_KEY, StringUtils.objectToString(objectList, (StringUtils.StringType)StringUtils.StringType.JSON, (boolean)Boolean.FALSE));
        return StringUtils.objectToString(convertMap, (StringUtils.StringType)StringUtils.StringType.JSON, (boolean)true);
    }
}

