/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.provider.factory;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.nervousync.database.annotations.provider.Provider;
import org.nervousync.database.provider.DataProvider;
import org.nervousync.database.provider.VerifyProvider;
import org.nervousync.utils.ObjectUtils;
import org.nervousync.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProviderFactory {
    private static final ProviderFactory INSTANCE = new ProviderFactory();
    private final Logger logger = LoggerFactory.getLogger(ProviderFactory.class);
    private final Hashtable<String, Class<?>> registeredDataProviders = new Hashtable();
    private final Hashtable<String, Class<?>> registeredVerifyProviders = new Hashtable();
    private String verifyProvider = "";

    private ProviderFactory() {
    }

    public static void register() {
        ServiceLoader.load(DataProvider.class).stream().filter(provider -> provider.getClass().isAnnotationPresent(Provider.class)).forEach(dataProvider -> {
            Class<?> providerClass = dataProvider.getClass();
            Provider provider = providerClass.getAnnotation(Provider.class);
            INSTANCE.registerDataProvider(provider.value(), providerClass);
        });
        ServiceLoader.load(VerifyProvider.class).stream().filter(provider -> provider.getClass().isAnnotationPresent(Provider.class)).forEach(verifyProvider -> {
            Class<?> providerClass = verifyProvider.getClass();
            Provider provider = providerClass.getAnnotation(Provider.class);
            INSTANCE.registerVerifyProvider(provider.value(), providerClass);
        });
    }

    public static ProviderFactory getInstance() {
        return INSTANCE;
    }

    public void setVerifyProvider(String verifyProvider) {
        this.verifyProvider = verifyProvider;
    }

    public static void destroy() {
        ProviderFactory.INSTANCE.registeredDataProviders.clear();
    }

    public static boolean registeredProvider(String providerName) {
        return ProviderFactory.INSTANCE.registeredDataProviders.containsKey(providerName);
    }

    public static boolean registeredVerifier(String providerName) {
        return ProviderFactory.INSTANCE.registeredVerifyProviders.containsKey(providerName);
    }

    public List<String> dataProviders() {
        ArrayList<String> providerList = new ArrayList<String>();
        this.registeredDataProviders.forEach((key, value) -> providerList.add((String)key));
        return providerList;
    }

    public List<String> verifyProviders() {
        ArrayList<String> providerList = new ArrayList<String>();
        this.registeredVerifyProviders.forEach((key, value) -> providerList.add((String)key));
        return providerList;
    }

    public Optional<DataProvider> dataProvider(String providerName) {
        Class<?> protectClass = this.registeredDataProviders.get(providerName);
        return Optional.ofNullable((DataProvider)ObjectUtils.newInstance(protectClass));
    }

    public VerifyProvider verifyProvider() {
        if (StringUtils.notBlank((String)this.verifyProvider) && this.registeredVerifyProviders.containsKey(this.verifyProvider)) {
            return (VerifyProvider)ObjectUtils.newInstance(this.registeredVerifyProviders.get(this.verifyProvider));
        }
        return null;
    }

    private void registerDataProvider(String providerName, Class<?> providerClass) {
        if (this.registeredDataProviders.containsKey(providerName)) {
            this.logger.warn("Override provider, name: {}, original class: {}, new class: {}", new Object[]{providerName, this.registeredDataProviders.get(providerName).getName(), providerClass.getName()});
        }
        this.registeredDataProviders.put(providerName, providerClass);
    }

    private void registerVerifyProvider(String providerName, Class<?> providerClass) {
        if (this.registeredVerifyProviders.containsKey(providerName)) {
            this.logger.warn("Override provider, name: {}, original class: {}, new class: {}", new Object[]{providerName, this.registeredVerifyProviders.get(providerName).getName(), providerClass.getName()});
        }
        this.registeredVerifyProviders.put(providerName, providerClass);
    }
}

