/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.operator.process;

import java.io.Serializable;
import org.nervousync.database.beans.configs.transactional.TransactionalConfig;
import org.nervousync.database.enumerations.operator.OperatorMode;
import org.nervousync.database.operator.result.OperateResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Operator
implements Serializable {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 4108130472521792519L;
    private final OperatorMode operatorMode;
    private final TransactionalConfig transactionalConfig;
    private final boolean readOnly;
    private OperateResult operateResult;

    protected Operator(OperatorMode operatorMode, boolean readOnly) {
        this.operatorMode = operatorMode;
        this.transactionalConfig = null;
        if (OperatorMode.Retrieve.equals((Object)operatorMode) || OperatorMode.Query.equals((Object)operatorMode)) {
            this.readOnly = readOnly;
        } else {
            if (readOnly) {
                this.logger.warn("Operator mode doesn't support read only mode, ignore read only config! ");
            }
            this.readOnly = Boolean.FALSE;
        }
    }

    protected Operator(OperatorMode operatorMode, TransactionalConfig transactionalConfig) {
        this.operatorMode = operatorMode;
        this.transactionalConfig = transactionalConfig;
        this.readOnly = Boolean.FALSE;
    }

    public static long getSerialVersionUID() {
        return 4108130472521792519L;
    }

    public OperatorMode getOperatorMode() {
        return this.operatorMode;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public TransactionalConfig getTransactionalConfig() {
        return this.transactionalConfig;
    }

    public OperateResult getOperateResult() {
        return this.operateResult;
    }

    public void setOperateResult(OperateResult operateResult) {
        this.operateResult = operateResult;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new ClassCastException("Can't convert from class " + this.getClass().getName() + " to class " + clazz.getName());
    }
}

