/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.entity.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.MappedSuperclass;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.nervousync.beans.core.BeanObject;
import org.nervousync.utils.ReflectionUtils;

@MappedSuperclass
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class BaseObject
extends BeanObject
implements Comparable<Object> {
    @JsonIgnore
    private boolean newObject = Boolean.TRUE;
    @JsonIgnore
    private Boolean forUpdate = null;
    @JsonIgnore
    private Long transactionalCode = null;
    @JsonIgnore
    private final List<String> modifiedColumns = new ArrayList<String>();
    @JsonIgnore
    private final List<String> loadedFields = new ArrayList<String>();

    public final boolean newObject() {
        return this.newObject;
    }

    public final boolean forUpdate() {
        return this.forUpdate != null && this.forUpdate != false;
    }

    public final List<String> modifiedColumns() {
        return this.modifiedColumns;
    }

    public final boolean dataModified() {
        return this.newObject() || this.forUpdate() && this.modifiedColumns.size() > 0;
    }

    public final void setForUpdate(Boolean forUpdate) {
        if (this.forUpdate == null) {
            this.forUpdate = forUpdate;
            this.newObject = Boolean.FALSE;
        }
    }

    public final Long getTransactionalCode() {
        return this.transactionalCode;
    }

    public final void setTransactionalCode(Long transactionalCode) {
        if (this.transactionalCode == null) {
            this.transactionalCode = transactionalCode;
        }
    }

    public final boolean loadedField(String fieldName) {
        return this.loadedFields.contains(fieldName);
    }

    public final void loadField(String fieldName) {
        if (this.loadedFields.contains(fieldName)) {
            return;
        }
        this.loadedFields.add(fieldName);
    }

    public final void modifyField(String fieldName) {
        if (this.modifiedColumns.contains(fieldName)) {
            return;
        }
        this.modifiedColumns.add(fieldName);
    }

    @Override
    public final int compareTo(Object o) {
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            throw new ClassCastException("Cannot compare instance of " + this.getClass().getName() + " to the instance of " + o.getClass().getName());
        }
        for (Field field : ReflectionUtils.getAllDeclaredFields(this.getClass())) {
            Object destValue;
            String fieldName;
            Object origValue;
            if (!Comparable.class.isAssignableFrom(field.getType()) || Objects.equals(origValue = ReflectionUtils.getFieldValue((String)(fieldName = field.getName()), (Object)this), destValue = ReflectionUtils.getFieldValue((String)fieldName, (Object)o))) continue;
            return ((Comparable)origValue).compareTo(destValue);
        }
        return 0;
    }
}

