/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import org.nervousync.database.beans.configs.table.TableConfig;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.SecurityUtils;
import org.nervousync.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityManager {
    private static final EntityManager INSTANCE = new EntityManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityManager.class);
    private final Hashtable<String, TableConfig> registeredTableConfig = new Hashtable();

    private EntityManager() {
    }

    public static EntityManager getInstance() {
        return INSTANCE;
    }

    public List<TableConfig> registerTable(Class<?> ... entityClasses) {
        ArrayList<TableConfig> registeredTables = new ArrayList<TableConfig>();
        Arrays.asList(entityClasses).forEach(entityClass -> TableConfig.newInstance(entityClass).ifPresent(tableConfig -> {
            if (this.tableExists((Class<?>)entityClass)) {
                LOGGER.warn("Override table config, entity class: {} table name: {}", (Object)entityClass.getName(), (Object)tableConfig.getTableName());
            }
            this.registeredTableConfig.put(tableConfig.getTableName(), (TableConfig)tableConfig);
            this.registeredTableConfig.put(entityClass.getName(), (TableConfig)tableConfig);
            this.registeredTableConfig.put(EntityManager.identifyKey(entityClass.getName()), (TableConfig)tableConfig);
            registeredTables.add((TableConfig)tableConfig);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Register class {} mapping to table {}", (Object)entityClass.getName(), (Object)tableConfig.getTableName());
            }
        }));
        return registeredTables;
    }

    public void removeTable(Class<?> ... entityClasses) {
        Arrays.stream(entityClasses).filter(entityClass -> this.registeredTableConfig.containsKey(entityClass.getName())).forEach(entityClass -> {
            TableConfig tableConfig = this.registeredTableConfig.get(entityClass.getName());
            this.registeredTableConfig.remove(tableConfig.getTableName());
            this.registeredTableConfig.remove(entityClass.getName());
            this.registeredTableConfig.remove(EntityManager.identifyKey(entityClass.getName()));
        });
    }

    public boolean tableExists(Class<?> defineClass) {
        return this.tableExists(defineClass.getName());
    }

    public boolean tableExists(String identifyKey) {
        if (StringUtils.isEmpty((CharSequence)identifyKey)) {
            return Boolean.FALSE;
        }
        return this.registeredTableConfig.containsKey(EntityManager.identifyKey(identifyKey));
    }

    public TableConfig retrieveTableConfig(Class<?> defineClass) {
        return this.retrieveTableConfig(defineClass.getName());
    }

    public TableConfig retrieveTableConfig(String identifyKey) {
        if (StringUtils.isEmpty((CharSequence)identifyKey)) {
            return null;
        }
        String mapKey = identifyKey.contains("$") ? identifyKey.substring(0, identifyKey.indexOf("$")) : identifyKey;
        return this.registeredTableConfig.get(mapKey);
    }

    public boolean matchSchema(Object object, String schemaName) {
        return Optional.ofNullable(this.retrieveTableConfig(object.getClass())).map(tableConfig -> tableConfig.getSchemaName().equals(schemaName)).orElse(Boolean.FALSE);
    }

    public static String identifyKey(String className) {
        String identifyName;
        if (StringUtils.isEmpty((CharSequence)className)) {
            return "";
        }
        String string = identifyName = className.contains("$") ? className.substring(0, className.indexOf("$")) : className;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Class identify name: {}", (Object)identifyName);
        }
        return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256((Object)identifyName));
    }

    public static void destroy() {
        EntityManager.INSTANCE.registeredTableConfig.clear();
    }
}

