/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.commons;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.nervousync.database.entity.EntityManager;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.SecurityUtils;
import org.nervousync.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseCommons.class);
    private static final Map<Class<?>, Integer> DATA_CONVERT_MAPPING = new HashMap();
    public static final int DEFAULT_PAGE_NO = 1;
    public static final int DEFAULT_PAGE_LIMIT = 20;
    public static final String DEFAULT_DATABASE_ALIAS = "DefaultDatabase";
    public static final String CONTENT_MAP_KEY_DATABASE_NAME = "NSYC_DATABASE_NAME";
    public static final String CONTENT_MAP_KEY_TABLE_NAME = "NSYC_TABLE_NAME";
    public static final String CONTENT_MAP_KEY_ITEM = "NSYC_CONTENT_ITEM";

    public static int retrieveJdbcType(Class<?> typeClass) {
        if (DATA_CONVERT_MAPPING.containsKey(typeClass)) {
            return DATA_CONVERT_MAPPING.get(typeClass);
        }
        return 1111;
    }

    public static void registerDataType(Class<?> fieldType, int jdbcType) {
        if (DATA_CONVERT_MAPPING.containsKey(fieldType)) {
            LOGGER.warn("Override type mapping: {}", (Object)fieldType.getName());
        }
        DATA_CONVERT_MAPPING.put(fieldType, jdbcType);
    }

    public static Map<String, String> cacheDataToMap(String cacheData) {
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        for (Map.Entry entry : StringUtils.dataToMap((String)cacheData, (StringUtils.StringType)StringUtils.StringType.JSON).entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            cacheMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return cacheMap;
    }

    public static void checkParameters(String defineClass) throws SecurityException {
        if (defineClass == null) {
            throw new SecurityException("Entity class is unknown");
        }
        if (!EntityManager.getInstance().tableExists(defineClass)) {
            throw new SecurityException("Can't found table define");
        }
    }

    public static String cacheKey(String defineClass, SortedMap<String, Object> queryParameters) {
        if (queryParameters == null || queryParameters.isEmpty()) {
            return null;
        }
        DatabaseCommons.checkParameters(defineClass);
        return Optional.ofNullable(EntityManager.getInstance().retrieveTableConfig(defineClass)).map(tableConfig -> {
            TreeMap<String, String> cacheKeyMap = new TreeMap<String, String>(queryParameters);
            cacheKeyMap.put(CONTENT_MAP_KEY_TABLE_NAME.toUpperCase(), tableConfig.getTableName().toUpperCase());
            return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(cacheKeyMap));
        }).orElse("");
    }

    static {
        DatabaseCommons.registerDataType(String.class, 12);
        DatabaseCommons.registerDataType(Integer.class, 4);
        DatabaseCommons.registerDataType(Integer.TYPE, 4);
        DatabaseCommons.registerDataType(Short.class, 5);
        DatabaseCommons.registerDataType(Short.TYPE, 5);
        DatabaseCommons.registerDataType(Long.class, -5);
        DatabaseCommons.registerDataType(Long.TYPE, -5);
        DatabaseCommons.registerDataType(Byte.class, -6);
        DatabaseCommons.registerDataType(Byte.TYPE, -6);
        DatabaseCommons.registerDataType(Float.class, 7);
        DatabaseCommons.registerDataType(Float.TYPE, 7);
        DatabaseCommons.registerDataType(Double.class, 8);
        DatabaseCommons.registerDataType(Double.TYPE, 8);
        DatabaseCommons.registerDataType(Boolean.class, 16);
        DatabaseCommons.registerDataType(Boolean.TYPE, 16);
        DatabaseCommons.registerDataType(Date.class, 93);
        DatabaseCommons.registerDataType(Calendar.class, 93);
        DatabaseCommons.registerDataType(Byte[].class, 2004);
        DatabaseCommons.registerDataType(byte[].class, 2004);
        DatabaseCommons.registerDataType(Character[].class, 2005);
        DatabaseCommons.registerDataType(char[].class, 2005);
        DatabaseCommons.registerDataType(BigDecimal.class, 3);
    }
}

