/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.beans.parser.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nervousync.database.beans.parser.AbstractDataParser;
import org.nervousync.utils.ClassUtils;

public final class BooleanDataParser
extends AbstractDataParser {
    @Override
    public <T> T parse(String value, Class<T> clazz) {
        Boolean boolValue = Boolean.valueOf(value);
        try {
            if (clazz.isPrimitive()) {
                String className = clazz.getName();
                String methodName = className + "Value";
                Method convertMethod = ClassUtils.findMethod((Class)ClassUtils.primitiveWrapper(clazz), (String)methodName);
                if (convertMethod != null) {
                    return (T)convertMethod.invoke((Object)boolValue, new Object[0]);
                }
            }
            return clazz.cast(boolValue);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }
}

