/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.beans.configs.transactional;

import java.io.Serializable;
import org.nervousync.database.annotations.transactional.Transactional;
import org.nervousync.database.enumerations.transactional.Isolation;
import org.nervousync.utils.IDUtils;

public final class TransactionalConfig
implements Serializable {
    private static final long serialVersionUID = 5195470765056859725L;
    private final long transactionalCode = IDUtils.snowflake();
    private final int timeout;
    private final Isolation isolation;
    private final Class<?>[] rollBackForClasses;

    private TransactionalConfig(Transactional transactional) {
        this.timeout = transactional.timeout();
        this.isolation = transactional.isolation();
        this.rollBackForClasses = transactional.rollbackFor();
    }

    public static TransactionalConfig initialize(Transactional transactional) {
        if (transactional != null) {
            return new TransactionalConfig(transactional);
        }
        return null;
    }

    public static long getSerialVersionUID() {
        return 5195470765056859725L;
    }

    public long getTransactionalCode() {
        return this.transactionalCode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Isolation getIsolation() {
        return this.isolation;
    }

    public Class<?>[] getRollBackForClasses() {
        return this.rollBackForClasses;
    }
}

