/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.beans.configs.table;

import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.nervousync.database.annotations.table.Options;
import org.nervousync.database.beans.configs.column.ColumnConfig;
import org.nervousync.database.beans.configs.generator.GeneratorConfig;
import org.nervousync.database.beans.configs.reference.ReferenceConfig;
import org.nervousync.database.commons.DatabaseCommons;
import org.nervousync.database.dialects.Converter;
import org.nervousync.database.entity.core.BaseObject;
import org.nervousync.database.enumerations.drop.DropOption;
import org.nervousync.database.enumerations.generation.GenerationOption;
import org.nervousync.database.enumerations.lock.LockOption;
import org.nervousync.database.exceptions.entity.TableConfigException;
import org.nervousync.database.exceptions.security.DataModifiedException;
import org.nervousync.database.provider.VerifyProvider;
import org.nervousync.database.provider.factory.ProviderFactory;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.IDUtils;
import org.nervousync.utils.ObjectUtils;
import org.nervousync.utils.ReflectionUtils;
import org.nervousync.utils.SecurityUtils;
import org.nervousync.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableConfig
implements Serializable {
    private static final long serialVersionUID = -6261205588355266688L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TableConfig.class);
    private final String schemaName;
    private final String tableName;
    private final boolean cacheable;
    private final Class<?> defineClass;
    private final List<ColumnConfig> columnConfigList = new ArrayList<ColumnConfig>();
    private final Index[] indexes;
    private final LockOption lockOption;
    private final DropOption dropOption;
    private final Hashtable<String, ReferenceConfig> referenceConfigs = new Hashtable();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TableConfig(Class<?> clazz) throws TableConfigException {
        Method[] methods;
        Table table = clazz.getAnnotation(Table.class);
        this.schemaName = StringUtils.isEmpty((CharSequence)table.schema()) ? "DefaultDatabase" : table.schema();
        boolean bl = this.cacheable = clazz.isAnnotationPresent(Cacheable.class) ? clazz.getAnnotation(Cacheable.class).value() : Boolean.FALSE.booleanValue();
        if (clazz.isAnnotationPresent(Options.class)) {
            Options options = clazz.getAnnotation(Options.class);
            this.lockOption = options.lockOption();
            this.dropOption = options.dropOption();
        } else {
            this.lockOption = LockOption.NONE;
            this.dropOption = DropOption.NONE;
        }
        this.indexes = table.indexes();
        this.tableName = StringUtils.notBlank((String)table.name()) ? table.name() : clazz.getSimpleName();
        this.defineClass = clazz;
        List<Field> fieldList = this.retrieveDeclaredFields(this.defineClass);
        Object object = ObjectUtils.newInstance(this.defineClass);
        for (Field field : fieldList) {
            ReferenceConfig referenceConfig;
            boolean returnArray;
            CascadeType[] cascadeType;
            if (field.isAnnotationPresent(Column.class)) {
                this.parseColumnField(field, object, field.isAnnotationPresent(Id.class)).ifPresent(this.columnConfigList::add);
                continue;
            }
            if (!TableConfig.lazyLoadField(field)) continue;
            String fieldName = field.getName();
            Class referenceClass = null;
            boolean lazyLoad = false;
            if (field.isAnnotationPresent(OneToMany.class)) {
                OneToMany oneToMany = field.getAnnotation(OneToMany.class);
                referenceClass = oneToMany.targetEntity();
                lazyLoad = FetchType.LAZY.equals((Object)oneToMany.fetch());
                cascadeType = oneToMany.cascade();
            } else if (field.isAnnotationPresent(ManyToOne.class)) {
                ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
                referenceClass = manyToOne.targetEntity();
                lazyLoad = FetchType.LAZY.equals((Object)manyToOne.fetch());
                cascadeType = manyToOne.cascade();
            } else if (field.isAnnotationPresent(OneToOne.class)) {
                OneToOne oneToOne = field.getAnnotation(OneToOne.class);
                referenceClass = oneToOne.targetEntity();
                lazyLoad = FetchType.LAZY.equals((Object)oneToOne.fetch());
                cascadeType = oneToOne.cascade();
            } else {
                cascadeType = new CascadeType[]{};
            }
            boolean bl2 = returnArray = List.class.isAssignableFrom(field.getType()) || field.getType().isArray();
            if (Void.TYPE.equals(referenceClass)) {
                if (returnArray) {
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        Type[] fieldTypes = ((ParameterizedType)type).getActualTypeArguments();
                        if (fieldTypes.length != 1) throw new TableConfigException("Reference configure error! Cannot found target entity class...");
                        referenceClass = (Class)fieldTypes[0];
                    }
                } else {
                    referenceClass = field.getType();
                }
            }
            if (referenceClass == null) continue;
            JoinColumn[] joinColumns = null;
            if (field.isAnnotationPresent(JoinColumns.class)) {
                JoinColumns annotationColumns = field.getAnnotation(JoinColumns.class);
                joinColumns = annotationColumns.value();
            } else if (field.isAnnotationPresent(JoinColumn.class)) {
                joinColumns = new JoinColumn[]{field.getAnnotation(JoinColumn.class)};
            }
            if ((referenceConfig = ReferenceConfig.initialize(referenceClass, fieldName, lazyLoad, returnArray, cascadeType, joinColumns)) == null) continue;
            this.referenceConfigs.put(fieldName, referenceConfig);
        }
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(clazz)) {
            CascadeType[] cascadeType;
            String methodName = method.getName();
            if (!method.isAnnotationPresent(OneToMany.class) && !method.isAnnotationPresent(ManyToOne.class) || !method.isAnnotationPresent(JoinColumns.class) && !method.isAnnotationPresent(JoinColumn.class) || !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            Class referenceClass = null;
            boolean lazyLoad = false;
            if (method.isAnnotationPresent(OneToMany.class)) {
                OneToMany oneToMany = method.getAnnotation(OneToMany.class);
                referenceClass = oneToMany.targetEntity();
                lazyLoad = FetchType.LAZY.equals((Object)oneToMany.fetch());
                cascadeType = oneToMany.cascade();
            } else if (method.isAnnotationPresent(ManyToOne.class)) {
                ManyToOne manyToOne = method.getAnnotation(ManyToOne.class);
                referenceClass = manyToOne.targetEntity();
                lazyLoad = FetchType.LAZY.equals((Object)manyToOne.fetch());
                cascadeType = manyToOne.cascade();
            } else {
                cascadeType = new CascadeType[]{};
            }
            if (referenceClass == null) continue;
            boolean returnArray = List.class.isAssignableFrom(method.getReturnType()) || method.getReturnType().isArray();
            JoinColumn[] joinColumns = null;
            if (method.isAnnotationPresent(JoinColumns.class)) {
                JoinColumns annotationColumns = method.getAnnotation(JoinColumns.class);
                joinColumns = annotationColumns.value();
            } else if (method.isAnnotationPresent(JoinColumn.class)) {
                joinColumns = new JoinColumn[]{method.getAnnotation(JoinColumn.class)};
            }
            ReferenceConfig referenceConfig = ReferenceConfig.initialize(referenceClass, ReflectionUtils.fieldName((String)methodName), lazyLoad, returnArray, cascadeType, joinColumns);
            if (referenceConfig == null) continue;
            this.referenceConfigs.put(methodName, referenceConfig);
        }
    }

    public static boolean lazyLoadField(Field field) {
        if (field == null) {
            return Boolean.FALSE;
        }
        return !(!field.isAnnotationPresent(OneToMany.class) && !field.isAnnotationPresent(ManyToOne.class) && !field.isAnnotationPresent(OneToOne.class) || !field.isAnnotationPresent(JoinColumns.class) && !field.isAnnotationPresent(JoinColumn.class));
    }

    public static Optional<TableConfig> newInstance(Class<?> clazz) {
        TableConfig tableConfig;
        block3: {
            tableConfig = null;
            if (clazz.isAnnotationPresent(Table.class)) {
                try {
                    tableConfig = new TableConfig(clazz);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Generate table config error! ", (Throwable)e);
                }
            }
        }
        return Optional.ofNullable(tableConfig);
    }

    public static long getSerialVersionUID() {
        return -6261205588355266688L;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public Class<?> getDefineClass() {
        return this.defineClass;
    }

    public List<ColumnConfig> getColumnConfigList() {
        return this.columnConfigList;
    }

    public Index[] getIndexes() {
        return this.indexes == null ? new Index[]{} : (Index[])this.indexes.clone();
    }

    public LockOption getLockOption() {
        return this.lockOption;
    }

    public DropOption getDropOption() {
        return this.dropOption;
    }

    public String identifyKey(Object object) {
        return this.identifyKey(object, "");
    }

    public String identifyKey(Object object, String itemKey) {
        if (object != null && this.defineClass.equals(object.getClass())) {
            TreeMap<String, String> dataMap = new TreeMap<String, String>();
            this.getColumnConfigList().stream().filter(ColumnConfig::isPrimaryKeyColumn).forEach(columnConfig -> dataMap.put(columnConfig.getColumnName().toUpperCase(), (String)ReflectionUtils.getFieldValue((String)columnConfig.getFieldName(), (Object)object)));
            dataMap.put("NSYC_DATABASE_NAME".toUpperCase(), this.schemaName.toUpperCase());
            dataMap.put("NSYC_TABLE_NAME".toUpperCase(), this.tableName.toUpperCase());
            if (StringUtils.notBlank((String)itemKey)) {
                dataMap.put("NSYC_CONTENT_ITEM".toUpperCase(), Optional.ofNullable(this.getColumnConfig(itemKey)).filter(ColumnConfig::isLazyLoad).map(columnConfig -> columnConfig.getColumnName().toUpperCase()).orElseThrow(() -> new TableConfigException("Can't found column define! Item key: " + itemKey)));
            }
            return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(dataMap));
        }
        return "";
    }

    public List<String> cacheKeys(Object object) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        SortedMap<String, Object> primaryKeyMap = this.generatePrimaryKeyMap(object);
        this.columnConfigList.stream().filter(ColumnConfig::isLazyLoad).forEach(columnConfig -> {
            TreeMap<String, Object> keyMap = new TreeMap<String, Object>(primaryKeyMap);
            keyMap.put("NSYC_CONTENT_ITEM".toUpperCase(), columnConfig.getColumnName());
            cacheKeys.add(DatabaseCommons.cacheKey(this.defineClass.getName(), keyMap));
        });
        cacheKeys.add(DatabaseCommons.cacheKey(this.defineClass.getName(), primaryKeyMap));
        return cacheKeys;
    }

    public String cacheKey(Object object, String fieldName) {
        return Optional.ofNullable(this.getColumnConfig(fieldName)).map(columnConfig -> {
            SortedMap<String, Object> keyMap = this.generatePrimaryKeyMap(object);
            keyMap.put("NSYC_CONTENT_ITEM".toUpperCase(), columnConfig.getColumnName());
            return this.cacheKey(keyMap);
        }).orElse("");
    }

    public String cacheKey(SortedMap<String, Object> primaryKey) {
        primaryKey.put("NSYC_DATABASE_NAME".toUpperCase(), this.schemaName);
        primaryKey.put("NSYC_TABLE_NAME".toUpperCase(), this.tableName);
        String jsonKey = StringUtils.objectToString(primaryKey, (StringUtils.StringType)StringUtils.StringType.JSON, (boolean)Boolean.FALSE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache key map: {}", (Object)jsonKey);
        }
        return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256((Object)jsonKey));
    }

    public void verify(Object object, long identifyCode) throws DataModifiedException {
        VerifyProvider verifyProvider = ProviderFactory.getInstance().verifyProvider();
        if (verifyProvider == null) {
            return;
        }
        verifyProvider.patch(object, identifyCode);
        if (verifyProvider.verify(object)) {
            return;
        }
        LOGGER.warn("Data record signature invalid! ");
        throw new DataModifiedException("Data record signature invalid! ");
    }

    public String columnName(String identifyName) {
        if (this.isColumn(identifyName)) {
            return Optional.ofNullable(this.getColumnConfig(identifyName)).map(ColumnConfig::getColumnName).orElse("");
        }
        return "";
    }

    public boolean isColumn(String identifyName) {
        return this.columnConfigList.stream().anyMatch(columnConfig -> columnConfig.matchIdentifyKey(identifyName));
    }

    public boolean isLazyLoad(String identifyName) {
        if (StringUtils.isEmpty((CharSequence)identifyName)) {
            return Boolean.FALSE;
        }
        for (ColumnConfig columnConfig : this.columnConfigList) {
            if (!columnConfig.matchIdentifyKey(identifyName)) continue;
            return columnConfig.isLazyLoad();
        }
        if (this.referenceConfigs.containsKey(identifyName)) {
            return this.referenceConfigs.get(identifyName).isLazyLoad();
        }
        return Boolean.FALSE;
    }

    public ColumnConfig getColumnConfig(String identifyName) {
        if (identifyName != null && identifyName.length() > 0) {
            for (ColumnConfig currentColumn : this.columnConfigList) {
                if (!currentColumn.matchIdentifyKey(identifyName)) continue;
                return currentColumn;
            }
        }
        return null;
    }

    public Optional<ColumnConfig> identifyVersionColumn() {
        ColumnConfig columnConfig = null;
        for (ColumnConfig currentColumn : this.columnConfigList) {
            if (!currentColumn.isIdentifyVersion()) continue;
            columnConfig = currentColumn;
        }
        return Optional.ofNullable(columnConfig);
    }

    public ReferenceConfig findReferenceConfig(String identifyName) {
        if (this.referenceConfigs.containsKey(identifyName)) {
            return this.referenceConfigs.get(identifyName);
        }
        for (ReferenceConfig referenceConfig : this.referenceConfigs.values()) {
            if (!referenceConfig.getReferenceClass().getName().equalsIgnoreCase(identifyName)) continue;
            return referenceConfig;
        }
        return null;
    }

    public Iterator<ReferenceConfig> referenceIterator() {
        return this.referenceConfigs.values().iterator();
    }

    public void generatePrimaryKey(Object object) {
        this.columnConfigList.stream().filter(ColumnConfig::isPrimaryKeyColumn).forEach(columnConfig -> {
            GeneratorConfig generatorConfig = columnConfig.getGeneratorConfig();
            Object generateValue = null;
            if (GenerationOption.GENERATOR.equals((Object)generatorConfig.getGenerationOption())) {
                switch (generatorConfig.getGeneratorName()) {
                    case "Snowflake": {
                        Object object2 = IDUtils.snowflake();
                        break;
                    }
                    case "NanoID": {
                        Object object2 = IDUtils.nano();
                        break;
                    }
                    case "UUIDv1": {
                        Object object2 = IDUtils.UUIDv1();
                        break;
                    }
                    case "UUIDv2": {
                        Object object2 = IDUtils.UUIDv2();
                        break;
                    }
                    case "UUIDv4": {
                        Object object2 = IDUtils.UUIDv4();
                        break;
                    }
                    default: {
                        Object object2 = generateValue = null;
                    }
                }
            }
            if (generateValue != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Generated value: {}", generateValue);
                }
                ReflectionUtils.setField((String)columnConfig.getFieldName(), (Object)object, generateValue);
            }
        });
    }

    public SortedMap<String, Object> generatePrimaryKeyMap(Object object) {
        return this.generatePrimaryKeyMap(object, Boolean.FALSE);
    }

    public SortedMap<String, Object> generatePrimaryKeyMap(Object object, boolean forUpdate) {
        TreeMap<String, Object> parameterMap = new TreeMap<String, Object>();
        if (this.defineClass.isAssignableFrom(object.getClass())) {
            this.columnConfigList.stream().filter(ColumnConfig::isPrimaryKeyColumn).forEach(columnConfig -> parameterMap.put(columnConfig.getColumnName(), ReflectionUtils.getFieldValue((String)columnConfig.getFieldName(), (Object)object)));
            if (forUpdate && LockOption.OPTIMISTIC_UPGRADE.equals((Object)this.lockOption)) {
                this.identifyVersionColumn().ifPresent(columnConfig -> parameterMap.put(columnConfig.getColumnName(), ReflectionUtils.getFieldValue((String)columnConfig.getFieldName(), (Object)object)));
            }
        }
        return parameterMap;
    }

    public SortedMap<String, Object> convertToDataMap(Object object, Converter converter) {
        TreeMap<String, Object> parameterMap = new TreeMap<String, Object>();
        if (this.defineClass.isAssignableFrom(object.getClass())) {
            this.columnConfigList.forEach(columnConfig -> Optional.ofNullable(this.retrieveValue(object, (ColumnConfig)columnConfig, converter)).ifPresent(fieldValue -> parameterMap.put(columnConfig.getColumnName(), fieldValue)));
        }
        return parameterMap;
    }

    public SortedMap<String, Object> convertToUpdateMap(Object object, Converter converter) {
        TreeMap<String, Object> parameterMap = new TreeMap<String, Object>();
        if (this.defineClass.isAssignableFrom(object.getClass())) {
            if (object instanceof BaseObject) {
                ((BaseObject)object).modifiedColumns().forEach(identifyKey -> Optional.ofNullable(this.getColumnConfig((String)identifyKey)).ifPresent(columnConfig -> parameterMap.put(columnConfig.getColumnName(), this.retrieveValue(object, (ColumnConfig)columnConfig, converter))));
            } else {
                this.columnConfigList.stream().filter(columnConfig -> !columnConfig.isPrimaryKeyColumn() && columnConfig.isUpdatable()).forEach(columnConfig -> parameterMap.put(columnConfig.getColumnName(), this.retrieveValue(object, (ColumnConfig)columnConfig, converter)));
            }
        }
        return parameterMap;
    }

    public Object retrieveValue(Object object, String identifyKey) {
        return Optional.ofNullable(this.getColumnConfig(identifyKey)).map(columnConfig -> this.retrieveValue(object, (ColumnConfig)columnConfig, null)).orElse(null);
    }

    private Object retrieveValue(Object object, ColumnConfig columnConfig, Converter converter) {
        Object columnValue = ReflectionUtils.getFieldValue((String)columnConfig.getFieldName(), (Object)object);
        if (columnValue == null || converter == null) {
            return columnValue;
        }
        return converter.convertValue(columnConfig, columnValue);
    }

    private Optional<ColumnConfig> parseColumnField(Field field, Object object, boolean primaryKeyColumn) {
        if (field.isAnnotationPresent(Version.class) && !LockOption.OPTIMISTIC_UPGRADE.equals((Object)this.lockOption)) {
            return Optional.empty();
        }
        if (!this.isColumn(field.getName())) {
            return Optional.of(ColumnConfig.newInstance(field, object, primaryKeyColumn));
        }
        return Optional.empty();
    }

    private List<Field> retrieveDeclaredFields(Class<?> clazz) {
        if (clazz != null) {
            ArrayList<Field> declaredFields = new ArrayList<Field>();
            declaredFields.addAll(this.retrieveSuperClassFields(clazz.getSuperclass()));
            declaredFields.addAll(this.annotationFields(clazz));
            return declaredFields;
        }
        return new ArrayList<Field>();
    }

    private List<Field> retrieveSuperClassFields(Class<?> clazz) {
        ArrayList<Field> declaredFields = new ArrayList<Field>();
        if (clazz != null) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                declaredFields.addAll(this.retrieveSuperClassFields(superClass));
            }
            if (clazz.isAnnotationPresent(MappedSuperclass.class)) {
                declaredFields.addAll(this.annotationFields(clazz));
            }
        }
        return declaredFields;
    }

    private List<Field> annotationFields(Class<?> clazz) {
        if (clazz == null) {
            return new ArrayList<Field>();
        }
        ArrayList<Field> declaredFields = new ArrayList<Field>();
        Arrays.stream(clazz.getDeclaredFields()).filter(this::annotationField).forEach(declaredFields::add);
        return declaredFields;
    }

    private boolean annotationField(Field field) {
        return field.isAnnotationPresent(Column.class) || field.isAnnotationPresent(EmbeddedId.class) || (field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(OneToOne.class)) && (field.isAnnotationPresent(JoinColumns.class) || field.isAnnotationPresent(JoinColumn.class));
    }
}

