/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.beans.configs.reference;

import jakarta.persistence.CascadeType;
import jakarta.persistence.JoinColumn;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nervousync.beans.core.BeanObject;
import org.nervousync.utils.StringUtils;

public final class ReferenceConfig
implements Serializable {
    private static final long serialVersionUID = 352330256621053556L;
    private final boolean lazyLoad;
    private final boolean returnArray;
    private final Class<?> referenceClass;
    private final String fieldName;
    private final CascadeType[] cascadeTypes;
    private final List<JoinColumnConfig> referenceColumnList = new ArrayList<JoinColumnConfig>();

    private ReferenceConfig(Class<?> referenceClass, String fieldName, boolean lazyLoad, boolean returnArray, CascadeType[] cascadeTypes, JoinColumn[] joinColumns) {
        this.lazyLoad = lazyLoad;
        this.returnArray = returnArray;
        this.cascadeTypes = cascadeTypes;
        this.fieldName = fieldName;
        this.referenceClass = referenceClass;
        for (JoinColumn joinColumn : joinColumns) {
            this.referenceColumnList.add(new JoinColumnConfig(joinColumn.columnDefinition(), joinColumn.referencedColumnName()));
        }
    }

    public static ReferenceConfig initialize(Class<?> referenceClass, String fieldName, boolean lazyLoad, boolean returnArray, CascadeType[] cascadeTypes, JoinColumn[] joinColumns) {
        if (joinColumns == null || cascadeTypes == null || StringUtils.isEmpty((CharSequence)fieldName) || joinColumns.length == 0) {
            return null;
        }
        return new ReferenceConfig(referenceClass, fieldName, lazyLoad, returnArray, cascadeTypes, joinColumns);
    }

    public static long getSerialVersionUID() {
        return 352330256621053556L;
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isReturnArray() {
        return this.returnArray;
    }

    public CascadeType[] getCascadeTypes() {
        return this.cascadeTypes == null ? new CascadeType[]{} : (CascadeType[])this.cascadeTypes.clone();
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public List<JoinColumnConfig> getReferenceColumnList() {
        return this.referenceColumnList;
    }

    @XmlRootElement
    public static final class JoinColumnConfig
    extends BeanObject {
        private static final long serialVersionUID = -5091778742481427204L;
        @XmlElement
        private final String currentField;
        @XmlElement
        private final String referenceField;

        JoinColumnConfig(String currentField, String referenceField) {
            this.currentField = currentField;
            this.referenceField = referenceField;
        }

        public static long getSerialVersionUID() {
            return -5091778742481427204L;
        }

        public String getCurrentField() {
            return this.currentField;
        }

        public String getReferenceField() {
            return this.referenceField;
        }
    }
}

