/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.beans.configs.generator;

import jakarta.persistence.GeneratedValue;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.nervousync.database.annotations.sequence.SequenceGenerator;
import org.nervousync.database.beans.configs.sequence.SequenceConfig;
import org.nervousync.database.enumerations.generation.GenerationOption;

public final class GeneratorConfig
implements Serializable {
    private static final long serialVersionUID = -4086799829735527877L;
    private final GenerationOption generationOption;
    private final String generatorName;
    private SequenceConfig sequenceConfig = null;

    public GeneratorConfig(Field field) {
        if (!field.isAnnotationPresent(GeneratedValue.class)) {
            this.generationOption = GenerationOption.NONE;
            this.generatorName = "";
            return;
        }
        GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
        switch (generatedValue.strategy()) {
            case SEQUENCE: {
                this.generationOption = GenerationOption.SEQUENCE;
                if (field.isAnnotationPresent(SequenceGenerator.class)) {
                    SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
                    this.generatorName = sequenceGenerator.name();
                    this.sequenceConfig = new SequenceConfig();
                    this.sequenceConfig.setMinValue(sequenceGenerator.min());
                    this.sequenceConfig.setMaxValue(sequenceGenerator.max());
                    this.sequenceConfig.setCurrent(sequenceGenerator.init());
                    this.sequenceConfig.setStep(sequenceGenerator.step());
                    this.sequenceConfig.setSequenceName(sequenceGenerator.name());
                    this.sequenceConfig.setCycle(sequenceGenerator.cycle());
                    break;
                }
                this.generatorName = "";
                break;
            }
            case IDENTITY: {
                this.generationOption = GenerationOption.INCREMENT;
                this.generatorName = "";
                break;
            }
            case AUTO: {
                this.generationOption = GenerationOption.GENERATOR;
                this.generatorName = generatedValue.generator();
                break;
            }
            default: {
                this.generationOption = GenerationOption.ASSIGNED;
                this.generatorName = "";
            }
        }
    }

    public static long getSerialVersionUID() {
        return -4086799829735527877L;
    }

    public GenerationOption getGenerationOption() {
        return this.generationOption;
    }

    public String getGeneratorName() {
        return this.generatorName;
    }

    public SequenceConfig getSequenceConfig() {
        return this.sequenceConfig;
    }

    public boolean sequenceGenerator() {
        return GenerationOption.SEQUENCE.equals((Object)this.generationOption);
    }
}

