/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.beans.configs.column;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.Temporal;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nervousync.database.annotations.table.DataParser;
import org.nervousync.database.beans.configs.generator.GeneratorConfig;
import org.nervousync.database.beans.parser.AbstractDataParser;
import org.nervousync.database.commons.DatabaseCommons;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.ReflectionUtils;
import org.nervousync.utils.SecurityUtils;
import org.nervousync.utils.StringUtils;

public final class ColumnConfig
implements Serializable {
    private static final long serialVersionUID = -6062009105869563215L;
    private final int length;
    private final int precision;
    private final int scale;
    private final String columnName;
    private final String fieldName;
    private final Class<?> fieldType;
    private final int jdbcType;
    private final Object defaultValue;
    private final boolean primaryKeyColumn;
    private final boolean nullable;
    private final boolean updatable;
    private final boolean unique;
    private final boolean lazyLoad;
    private final boolean identifyVersion;
    private final Class<? extends AbstractDataParser> parserClass;
    private final GeneratorConfig generatorConfig;
    private final List<String> identifyKeys = new ArrayList<String>();

    private ColumnConfig(Field field, Object object, boolean primaryKeyColumn) {
        Column column = field.getAnnotation(Column.class);
        this.columnName = column.name().length() == 0 ? field.getName() : column.name();
        this.identifyKeys.add(this.columnName);
        this.identifyKeys.add(ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256((Object)this.columnName)));
        this.precision = column.precision();
        this.scale = column.scale();
        this.fieldName = field.getName();
        this.identifyKeys.add(this.fieldName);
        this.identifyKeys.add(ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256((Object)this.fieldName)));
        this.fieldType = field.getType();
        if (Date.class.equals(this.fieldType) && field.isAnnotationPresent(Temporal.class)) {
            switch (field.getAnnotation(Temporal.class).value()) {
                case DATE: {
                    this.jdbcType = 91;
                    break;
                }
                case TIME: {
                    this.jdbcType = 92;
                    break;
                }
                default: {
                    this.jdbcType = 93;
                    break;
                }
            }
        } else {
            this.jdbcType = field.isAnnotationPresent(Lob.class) ? (String.class.equals(this.fieldType) || char[].class.equals(this.fieldType) || Character[].class.equals(this.fieldType) ? 2005 : 2004) : DatabaseCommons.retrieveJdbcType(this.fieldType);
        }
        switch (this.jdbcType) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                this.length = column.length();
                break;
            }
            default: {
                this.length = -1;
            }
        }
        this.defaultValue = ReflectionUtils.getFieldValue((String)field.getName(), (Object)object);
        this.primaryKeyColumn = primaryKeyColumn;
        if (this.primaryKeyColumn) {
            this.nullable = Boolean.FALSE;
            this.updatable = Boolean.FALSE;
            this.identifyVersion = Boolean.FALSE;
        } else {
            this.nullable = this.jdbcType == 93 ? Boolean.FALSE.booleanValue() : column.nullable();
            this.updatable = column.updatable();
            this.identifyVersion = field.isAnnotationPresent(Version.class);
        }
        this.parserClass = field.isAnnotationPresent(DataParser.class) ? field.getAnnotation(DataParser.class).value() : AbstractDataParser.class;
        this.unique = column.unique();
        this.lazyLoad = field.isAnnotationPresent(Basic.class) ? FetchType.LAZY.equals((Object)field.getAnnotation(Basic.class).fetch()) : Boolean.FALSE.booleanValue();
        this.generatorConfig = new GeneratorConfig(field);
    }

    public static ColumnConfig newInstance(Field field, Object object, boolean primaryKeyColumn) {
        if (field != null && object != null && field.isAnnotationPresent(Column.class)) {
            return new ColumnConfig(field, object, primaryKeyColumn);
        }
        return null;
    }

    public boolean matchIdentifyKey(String identifyName) {
        if (StringUtils.isEmpty((CharSequence)identifyName)) {
            return Boolean.FALSE;
        }
        return this.identifyKeys.stream().anyMatch(identifyKey -> identifyKey.equalsIgnoreCase(identifyName));
    }

    public static long getSerialVersionUID() {
        return -6062009105869563215L;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public boolean isIdentifyVersion() {
        return this.identifyVersion;
    }

    public Class<? extends AbstractDataParser> getParserClass() {
        return this.parserClass;
    }

    public GeneratorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }
}

