/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;

@Description(value="Clones a subgraph (an example taken from a community mailing list requirement)")
public class GraphCloner
extends ServerPlugin {
    public GraphCloner() {
        super("GraphCloner");
    }

    @PluginTarget(value=Node.class)
    public Node clonedSubgraph(@Source Node startNode, @Parameter(name="depth", optional=false) Integer depth) {
        GraphDatabaseService graphDb = startNode.getGraphDatabase();
        try (Transaction tx = graphDb.beginTx();){
            Traverser traverse = this.traverseToDepth(graphDb, startNode, depth);
            ResourceIterator nodes = traverse.nodes().iterator();
            HashMap<Node, Node> clonedNodes = this.cloneNodes(graphDb, (Iterator<Node>)nodes);
            for (Node oldNode : clonedNodes.keySet()) {
                Node newStartNode = clonedNodes.get(oldNode);
                for (Relationship oldRelationship : oldNode.getRelationships(Direction.OUTGOING)) {
                    Node newEndNode = clonedNodes.get(oldRelationship.getEndNode());
                    if (newEndNode == null) continue;
                    Relationship newRelationship = newStartNode.createRelationshipTo(newEndNode, oldRelationship.getType());
                    this.cloneProperties(oldRelationship, newRelationship);
                }
            }
            tx.success();
            Node node = clonedNodes.get(startNode);
            return node;
        }
    }

    private void cloneProperties(Relationship oldRelationship, Relationship newRelationship) {
        for (Map.Entry property : oldRelationship.getAllProperties().entrySet()) {
            newRelationship.setProperty((String)property.getKey(), property.getValue());
        }
    }

    private Traverser traverseToDepth(GraphDatabaseService graphDb, Node startNode, int depth) {
        TraversalDescription traversalDescription = graphDb.traversalDescription().expand(PathExpanders.allTypesAndDirections()).depthFirst().evaluator(path -> {
            if (path.length() < depth) {
                return Evaluation.INCLUDE_AND_CONTINUE;
            }
            return Evaluation.INCLUDE_AND_PRUNE;
        });
        return traversalDescription.traverse(startNode);
    }

    private Node cloneNodeData(GraphDatabaseService graphDb, Node node) {
        Node newNode = graphDb.createNode();
        for (Map.Entry property : node.getAllProperties().entrySet()) {
            newNode.setProperty((String)property.getKey(), property.getValue());
        }
        return newNode;
    }

    private HashMap<Node, Node> cloneNodes(GraphDatabaseService graphDb, Iterator<Node> nodes) {
        HashMap<Node, Node> result = new HashMap<Node, Node>();
        while (nodes.hasNext()) {
            Node next = nodes.next();
            result.put(next, this.cloneNodeData(graphDb, next));
        }
        return result;
    }
}

