/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class CloneSubgraphPluginTestIT
extends ExclusiveServerTestBase {
    private static final RelationshipType KNOWS = RelationshipType.withName((String)"knows");
    private static final RelationshipType WORKED_FOR = RelationshipType.withName((String)"worked_for");
    private static NeoServer server;
    private static FunctionalTestHelper functionalTestHelper;
    private Node jw;

    @BeforeClass
    public static void setupServer() throws IOException {
        server = ServerHelper.createNonPersistentServer();
        functionalTestHelper = new FunctionalTestHelper(server);
    }

    @AfterClass
    public static void shutdownServer() {
        try {
            if (server != null) {
                server.stop();
            }
        }
        finally {
            server = null;
        }
    }

    @Before
    public void setupTheDatabase() {
        ServerHelper.cleanTheDatabase((NeoServer)server);
        this.createASocialNetwork((GraphDatabaseService)server.getDatabase().getGraph());
    }

    private void createASocialNetwork(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            this.jw = db.createNode();
            this.jw.setProperty("name", (Object)"jim");
            Node sp = db.createNode();
            sp.setProperty("name", (Object)"savas");
            Node bg = db.createNode();
            bg.setProperty("name", (Object)"bill");
            Node th = db.createNode();
            th.setProperty("name", (Object)"tony");
            Node rj = db.createNode();
            rj.setProperty("name", (Object)"rhodri");
            rj.setProperty("hobby", (Object)"family");
            Node nj = db.createNode();
            nj.setProperty("name", (Object)"ned");
            nj.setProperty("hobby", (Object)"cs");
            Node ml = db.createNode();
            ml.setProperty("name", (Object)"mark");
            Node mf = db.createNode();
            mf.setProperty("name", (Object)"martin");
            Node rp = db.createNode();
            rp.setProperty("name", (Object)"rebecca");
            Node rs = db.createNode();
            rs.setProperty("name", (Object)"roy");
            Node sc = db.createNode();
            sc.setProperty("name", (Object)"steve");
            sc.setProperty("hobby", (Object)"cloud");
            Node sw = db.createNode();
            sw.setProperty("name", (Object)"stuart");
            sw.setProperty("hobby", (Object)"cs");
            this.jw.createRelationshipTo(sp, KNOWS);
            this.jw.createRelationshipTo(mf, KNOWS);
            this.jw.createRelationshipTo(rj, KNOWS);
            rj.createRelationshipTo(nj, KNOWS);
            mf.createRelationshipTo(rp, KNOWS);
            mf.createRelationshipTo(rs, KNOWS);
            sp.createRelationshipTo(bg, KNOWS);
            sp.createRelationshipTo(th, KNOWS);
            sp.createRelationshipTo(mf, KNOWS);
            sp.createRelationshipTo(ml, WORKED_FOR);
            ml.createRelationshipTo(sc, KNOWS);
            ml.createRelationshipTo(sw, KNOWS);
            this.jw.setProperty("hobby", (Object)"cs");
            sp.setProperty("hobby", (Object)"cs");
            bg.setProperty("hobby", (Object)"cs");
            ml.setProperty("hobby", (Object)"cs");
            mf.setProperty("hobby", (Object)"cs");
            rp.setProperty("hobby", (Object)"lisp");
            rs.setProperty("hobby", (Object)"socialism");
            th.setProperty("hobby", (Object)"fishing");
            tx.success();
        }
    }

    @Test
    public void shouldAdvertiseExtensionThatPluginCreates() throws JsonParseException, ClientHandlerException, UniformInterfaceException {
        int originalCount = this.nodeCount();
        JaxRsResponse response = new RestRequest().get(functionalTestHelper.dataUri() + "node/1");
        String entity = response.getEntity();
        Map map = JsonHelper.jsonToMap((String)entity);
        HashMap extensionsMap = (HashMap)map.get("extensions");
        Assert.assertNotNull((Object)extensionsMap);
        Assert.assertFalse((boolean)extensionsMap.isEmpty());
        String GRAPH_CLONER_KEY = "GraphCloner";
        Assert.assertTrue((boolean)extensionsMap.keySet().contains("GraphCloner"));
        String CLONE_SUBGRAPH_KEY = "clonedSubgraph";
        String clonedSubgraphUri = (String)((HashMap)extensionsMap.get("GraphCloner")).get("clonedSubgraph");
        Assert.assertNotNull((Object)clonedSubgraphUri);
        String CLONE_DEPTH_MUCH_LARGER_THAN_THE_GRAPH = "99";
        response.close();
        response = new RestRequest().post(clonedSubgraphUri, "depth=99", MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        Assert.assertEquals((String)response.getEntity(), (long)200L, (long)response.getStatus());
        int doubleTheNumberOfNodes = originalCount * 2;
        Assert.assertEquals((long)doubleTheNumberOfNodes, (long)this.nodeCount());
    }

    private int nodeCount() {
        try (Transaction ignore = server.getDatabase().getGraph().beginTx();){
            int n = Math.toIntExact(server.getDatabase().getGraph().getAllNodes().stream().count());
            return n;
        }
    }
}

