/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;

public class PluginFunctionalTestHelper {
    private PluginFunctionalTestHelper() {
    }

    public static Map<String, Object> makeGet(String url) throws JsonParseException {
        JaxRsResponse response = new RestRequest().get(url);
        String body = PluginFunctionalTestHelper.getResponseText(response);
        response.close();
        return PluginFunctionalTestHelper.deserializeMap(body);
    }

    protected static Map<String, Object> deserializeMap(String body) throws JsonParseException {
        Map result = JsonHelper.jsonToMap((String)body);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)IsNull.nullValue())));
        return result;
    }

    private static List<Map<String, Object>> deserializeList(String body) throws JsonParseException {
        List result = JsonHelper.jsonToList((String)body);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)IsNull.nullValue())));
        return result;
    }

    protected static String getResponseText(JaxRsResponse response) {
        String body = response.getEntity();
        Assert.assertEquals((String)body, (long)200L, (long)response.getStatus());
        return body;
    }

    protected static Map<String, Object> makePostMap(String url) throws JsonParseException {
        JaxRsResponse response = new RestRequest().post(url, null);
        String body = PluginFunctionalTestHelper.getResponseText(response);
        response.close();
        return PluginFunctionalTestHelper.deserializeMap(body);
    }

    protected static Map<String, Object> makePostMap(String url, Map<String, Object> params) throws JsonParseException {
        String json = JsonHelper.createJsonFrom(params);
        JaxRsResponse response = new RestRequest().post(url, json, MediaType.APPLICATION_JSON_TYPE);
        String body = PluginFunctionalTestHelper.getResponseText(response);
        response.close();
        return PluginFunctionalTestHelper.deserializeMap(body);
    }

    protected static List<Map<String, Object>> makePostList(String url) throws JsonParseException {
        JaxRsResponse response = new RestRequest().post(url, null);
        String body = PluginFunctionalTestHelper.getResponseText(response);
        response.close();
        return PluginFunctionalTestHelper.deserializeList(body);
    }

    protected static List<Map<String, Object>> makePostList(String url, Map<String, Object> params) throws JsonParseException {
        String json = JsonHelper.createJsonFrom(params);
        JaxRsResponse response = new RestRequest().post(url, json);
        String body = PluginFunctionalTestHelper.getResponseText(response);
        response.close();
        return PluginFunctionalTestHelper.deserializeList(body);
    }

    public static class RegExp
    extends TypeSafeMatcher<String> {
        private final String pattern;
        private String string;
        private final MatchType type;

        RegExp(String regexp, MatchType type) {
            this.pattern = regexp;
            this.type = type;
        }

        @Factory
        public static Matcher<String> endsWith(String pattern) {
            return new RegExp(pattern, MatchType.end);
        }

        public boolean matchesSafely(String string) {
            this.string = string;
            return this.type.match(this.pattern, string);
        }

        public void describeTo(Description descr) {
            descr.appendText("expected something that ").appendText(this.type.description).appendText(" [").appendText(this.pattern).appendText("] but got [").appendText(this.string).appendText("]");
        }

        static enum MatchType {
            end("ends with"){

                @Override
                boolean match(String pattern, String string) {
                    return string.endsWith(pattern);
                }
            }
            ,
            matches{

                @Override
                boolean match(String pattern, String string) {
                    return string.matches(pattern);
                }
            };

            private final String description;

            abstract boolean match(String var1, String var2);

            private MatchType() {
                this.description = this.name();
            }

            private MatchType(String description) {
                this.description = description;
            }
        }
    }
}

