/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;

@Description(value="Here you can describe your plugin. It will show up in the description of the methods.")
public class FunctionalTestPlugin
extends ServerPlugin {
    public static final String CREATE_NODE = "createNode";
    public static final String GET_CONNECTED_NODES = "connected_nodes";
    static String _string;
    static Byte _byte;
    static Character _character;
    static Integer _integer;
    static Short _short;
    static Long _long;
    static Float _float;
    static Double _double;
    static Boolean _boolean;
    static Long optional;
    static Set<String> stringSet;
    static List<String> stringList;
    static String[] stringArray;
    public static int[] intArray;

    @Name(value="connected_nodes")
    @PluginTarget(value=Node.class)
    public Iterable<Node> getAllConnectedNodes(@Source Node start) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try (Transaction tx = start.getGraphDatabase().beginTx();){
            for (Relationship rel : start.getRelationships()) {
                nodes.add(rel.getOtherNode(start));
            }
            tx.success();
        }
        return nodes;
    }

    @PluginTarget(value=Node.class)
    public Iterable<Relationship> getRelationshipsBetween(@Source Node start, @Parameter(name="other") Node end) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        try (Transaction tx = start.getGraphDatabase().beginTx();){
            for (Relationship relationship : start.getRelationships()) {
                if (!relationship.getOtherNode(start).equals(end)) continue;
                result.add(relationship);
            }
            tx.success();
        }
        return result;
    }

    @PluginTarget(value=Node.class)
    public Iterable<Relationship> createRelationships(@Source Node start, @Parameter(name="type") RelationshipType type, @Parameter(name="nodes") Iterable<Node> nodes) {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        try (Transaction tx = start.getGraphDatabase().beginTx();){
            for (Node end : nodes) {
                result.add(start.createRelationshipTo(end, type));
            }
            tx.success();
        }
        return result;
    }

    @PluginTarget(value=Node.class)
    public Node getThisNodeOrById(@Source Node start, @Parameter(name="id", optional=true) Long id) {
        optional = id;
        if (id == null) {
            return start;
        }
        try (Transaction tx = start.getGraphDatabase().beginTx();){
            Node node = start.getGraphDatabase().getNodeById(id.longValue());
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node createNode(@Source GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithIntParam(@Source GraphDatabaseService db, @Parameter(name="id", optional=false) int id) {
        try (Transaction tx = db.beginTx();){
            Node node = db.getNodeById((long)id);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    @PluginTarget(value=Relationship.class)
    public Iterable<Node> methodOnRelationship(@Source Relationship rel) {
        try (Transaction tx = rel.getGraphDatabase().beginTx();){
            List<Node> nodes = Arrays.asList(rel.getNodes());
            tx.success();
            List<Node> list = nodes;
            return list;
        }
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithAllParams(@Source GraphDatabaseService db, @Parameter(name="id", optional=false) String a, @Parameter(name="id2", optional=false) Byte b, @Parameter(name="id3", optional=false) Character c, @Parameter(name="id4", optional=false) Short d, @Parameter(name="id5", optional=false) Integer e, @Parameter(name="id6", optional=false) Long f, @Parameter(name="id7", optional=false) Float g, @Parameter(name="id8", optional=false) Double h, @Parameter(name="id9", optional=false) Boolean i) {
        _string = a;
        _byte = b;
        _character = c;
        _short = d;
        _integer = e;
        _long = f;
        _float = g;
        _double = h;
        _boolean = i;
        return this.getOrCreateANode(db);
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithSet(@Source GraphDatabaseService db, @Parameter(name="strings", optional=false) Set<String> params) {
        stringSet = params;
        return this.getOrCreateANode(db);
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithList(@Source GraphDatabaseService db, @Parameter(name="strings", optional=false) List<String> params) {
        stringList = params;
        return this.getOrCreateANode(db);
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithListAndInt(@Source GraphDatabaseService db, @Parameter(name="strings", optional=false) List<String> params, @Parameter(name="count", optional=false) int i) {
        stringList = params;
        _integer = i;
        return this.getOrCreateANode(db);
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithArray(@Source GraphDatabaseService db, @Parameter(name="strings", optional=false) String[] params) {
        stringArray = params;
        return this.getOrCreateANode(db);
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithIntArray(@Source GraphDatabaseService db, @Parameter(name="ints", optional=false) int[] params) {
        intArray = params;
        return this.getOrCreateANode(db);
    }

    @PluginTarget(value=GraphDatabaseService.class)
    public Node methodWithOptionalArray(@Source GraphDatabaseService db, @Parameter(name="ints", optional=true) int[] params) {
        intArray = params;
        return this.getOrCreateANode(db);
    }

    @PluginTarget(value=Node.class)
    public Path pathToReference(@Source Node me) {
        PathFinder finder = GraphAlgoFactory.shortestPath((PathExpander)PathExpanders.allTypesAndDirections(), (int)6);
        try (Transaction tx = me.getGraphDatabase().beginTx();){
            Node other;
            if (me.hasRelationship(new RelationshipType[]{RelationshipType.withName((String)"friend")})) {
                ResourceIterable relationships = (ResourceIterable)me.getRelationships(new RelationshipType[]{RelationshipType.withName((String)"friend")});
                try (ResourceIterator resourceIterator = relationships.iterator();){
                    other = ((Relationship)resourceIterator.next()).getOtherNode(me);
                }
            } else {
                other = me.getGraphDatabase().createNode();
            }
            Path path = finder.findSinglePath(other, me);
            tx.success();
            Path path2 = path;
            return path2;
        }
    }

    private Node getOrCreateANode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node;
            try {
                node = db.getNodeById(0L);
            }
            catch (NotFoundException e) {
                node = db.createNode();
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }
}

