/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.plugins.FunctionalTestPlugin;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.repr.formats.NullFormat;
import org.neo4j.test.TestGraphDatabaseFactory;

public class PluginManagerTest {
    private static PluginManager manager;
    private static GraphDatabaseAPI graphDb;

    @BeforeClass
    public static void loadExtensionManager() throws Exception {
        graphDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        manager = new PluginManager(null, (LogProvider)NullLogProvider.getInstance());
    }

    @AfterClass
    public static void destroyExtensionManager() {
        manager = null;
        if (graphDb != null) {
            graphDb.shutdown();
        }
        graphDb = null;
    }

    @Test
    public void canGetUrisForNode() throws Exception {
        Map extensions = manager.getExensionsFor(GraphDatabaseService.class);
        List methods = (List)extensions.get(FunctionalTestPlugin.class.getSimpleName());
        Assert.assertNotNull((Object)methods);
        Assert.assertThat((Object)methods, (Matcher)Matchers.hasItem((Object)"createNode"));
    }

    @Test
    public void canInvokeExtension() throws Exception {
        manager.invoke(graphDb, FunctionalTestPlugin.class.getSimpleName(), GraphDatabaseService.class, "createNode", (Object)graphDb, new NullFormat(null, (MediaType[])null).readParameterList(""));
    }
}

