/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.plugins.FunctionalTestPlugin;
import org.neo4j.server.plugins.PluginFunctionalTestHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.NodeRepresentationTest;
import org.neo4j.server.rest.repr.RelationshipRepresentationTest;
import org.neo4j.test.server.SharedServerTestBase;

public class PluginFunctionalTestIT
extends SharedServerTestBase {
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(SharedServerTestBase.server());
    }

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase((NeoServer)SharedServerTestBase.server());
    }

    @Test
    public void canGetGraphDatabaseExtensionList() throws Exception {
        Map<String, Object> map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.dataUri());
        Assert.assertThat((Object)map.get("extensions"), (Matcher)Matchers.instanceOf(Map.class));
    }

    @Test
    public void canGetExtensionDefinitionForReferenceNodeExtension() throws Exception {
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.dataUri());
        map = (Map)map.get("extensions");
        Assert.assertThat(map.get(FunctionalTestPlugin.class.getSimpleName()), (Matcher)Matchers.instanceOf(Map.class));
    }

    @Test
    public void canGetExtensionDataForCreateNode() throws Exception {
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.dataUri());
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        Assert.assertThat((Object)((String)map.get("createNode")), PluginFunctionalTestHelper.RegExp.endsWith(String.format("/ext/%s/graphdb/%s", FunctionalTestPlugin.class.getSimpleName(), "createNode")));
    }

    @Test
    public void canGetExtensionDescription() throws Exception {
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.dataUri());
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        String uri = (String)map.get("createNode");
        PluginFunctionalTestHelper.makeGet(uri);
    }

    @Test
    public void canInvokeExtensionMethodWithNoArguments() throws Exception {
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.dataUri());
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        String uri = (String)map.get("createNode");
        Map<String, Object> description = PluginFunctionalTestHelper.makePostMap(uri);
        NodeRepresentationTest.verifySerialisation(description);
    }

    @Test
    public void canInvokeNodePlugin() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.nodeUri(n));
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        String uri = (String)map.get("connected_nodes");
        List<Map<String, Object>> response = PluginFunctionalTestHelper.makePostList(uri);
        this.verifyNodes(response);
    }

    private void verifyNodes(List<Map<String, Object>> response) {
        for (Map<String, Object> nodeMap : response) {
            NodeRepresentationTest.verifySerialisation(nodeMap);
        }
    }

    @Test
    public void canInvokePluginWithParam() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.dataUri());
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        String uri = (String)map.get("methodWithIntParam");
        Map params = MapUtil.map((Object[])new Object[]{"id", n});
        Map<String, Object> node = PluginFunctionalTestHelper.makePostMap(uri, params);
        NodeRepresentationTest.verifySerialisation(node);
    }

    @Test
    public void canInvokePluginOnRelationship() throws Exception {
        long n1 = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        long n2 = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        long relId = functionalTestHelper.getGraphDbHelper().createRelationship("pals", n1, n2);
        String uri = this.getPluginMethodUri(functionalTestHelper.relationshipUri(relId), "methodOnRelationship");
        Map params = MapUtil.map((Object[])new Object[]{"id", relId});
        List<Map<String, Object>> nodes = PluginFunctionalTestHelper.makePostList(uri, params);
        this.verifyNodes(nodes);
    }

    private String getPluginMethodUri(String startUrl, String methodName) throws JsonParseException {
        Map map = PluginFunctionalTestHelper.makeGet(startUrl);
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        return (String)map.get(methodName);
    }

    @Test
    public void shouldBeAbleToInvokePluginWithLotsOfParams() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithAllParams");
        String a = "a";
        byte b = -1;
        char c = 'c';
        short d = 4;
        int e = 365;
        long f = 4L;
        float g = 4.5f;
        double h = Math.PI;
        boolean i = false;
        Map params = MapUtil.map((Object[])new Object[]{"id", a, "id2", b, "id3", Character.valueOf(c), "id4", d, "id5", e, "id6", f, "id7", Float.valueOf(g), "id8", h, "id9", i});
        PluginFunctionalTestHelper.makePostMap(methodUri, params);
        Assert.assertThat((Object)FunctionalTestPlugin._string, (Matcher)CoreMatchers.is((Object)a));
        Assert.assertThat((Object)FunctionalTestPlugin._byte, (Matcher)CoreMatchers.is((Object)b));
        Assert.assertThat((Object)FunctionalTestPlugin._character, (Matcher)CoreMatchers.is((Object)Character.valueOf(c)));
        Assert.assertThat((Object)FunctionalTestPlugin._short, (Matcher)CoreMatchers.is((Object)d));
        Assert.assertThat((Object)FunctionalTestPlugin._integer, (Matcher)CoreMatchers.is((Object)e));
        Assert.assertThat((Object)FunctionalTestPlugin._long, (Matcher)CoreMatchers.is((Object)f));
        Assert.assertThat((Object)FunctionalTestPlugin._float, (Matcher)CoreMatchers.is((Object)Float.valueOf(g)));
        Assert.assertThat((Object)FunctionalTestPlugin._double, (Matcher)CoreMatchers.is((Object)h));
        Assert.assertThat((Object)FunctionalTestPlugin._boolean, (Matcher)CoreMatchers.is((Object)i));
    }

    @Test
    public void shouldHandleOptionalValuesCorrectly1() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        String methodUri = this.getPluginMethodUri(functionalTestHelper.nodeUri(n), "getThisNodeOrById");
        Map<String, Object> map = PluginFunctionalTestHelper.makePostMap(methodUri);
        NodeRepresentationTest.verifySerialisation(map);
    }

    @Test
    public void shouldHandleOptionalValuesCorrectly2() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        String methodUri = this.getPluginMethodUri(functionalTestHelper.nodeUri(n), "getThisNodeOrById");
        long id = functionalTestHelper.getGraphDbHelper().getFirstNode();
        Map params = MapUtil.map((Object[])new Object[]{"id", id});
        PluginFunctionalTestHelper.makePostMap(methodUri, params);
        Assert.assertThat((Object)FunctionalTestPlugin.optional, (Matcher)CoreMatchers.is((Object)id));
    }

    @Test
    public void canInvokePluginWithNodeParam() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        long m = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        functionalTestHelper.getGraphDbHelper().createRelationship("LOVES", n, m);
        functionalTestHelper.getGraphDbHelper().createRelationship("LOVES", m, n);
        functionalTestHelper.getGraphDbHelper().createRelationship("KNOWS", m, functionalTestHelper.getGraphDbHelper().createNode(new Label[0]));
        functionalTestHelper.getGraphDbHelper().createRelationship("KNOWS", n, functionalTestHelper.getGraphDbHelper().createNode(new Label[0]));
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.nodeUri(n));
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        String uri = (String)map.get("getRelationshipsBetween");
        List<Map<String, Object>> response = PluginFunctionalTestHelper.makePostList(uri, MapUtil.map((Object[])new Object[]{"other", functionalTestHelper.nodeUri(m)}));
        Assert.assertEquals((long)2L, (long)response.size());
        this.verifyRelationships(response);
    }

    @Test
    public void canInvokePluginWithNodeListParam() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        Map map = PluginFunctionalTestHelper.makeGet(functionalTestHelper.nodeUri(n));
        map = (Map)map.get("extensions");
        map = (Map)map.get(FunctionalTestPlugin.class.getSimpleName());
        List<String> nodes = Arrays.asList(functionalTestHelper.nodeUri(functionalTestHelper.getGraphDbHelper().createNode(new Label[0])), functionalTestHelper.nodeUri(functionalTestHelper.getGraphDbHelper().createNode(new Label[0])), functionalTestHelper.nodeUri(functionalTestHelper.getGraphDbHelper().createNode(new Label[0])));
        String uri = (String)map.get("createRelationships");
        List<Map<String, Object>> response = PluginFunctionalTestHelper.makePostList(uri, MapUtil.map((Object[])new Object[]{"type", "KNOWS", "nodes", nodes}));
        Assert.assertEquals((long)nodes.size(), (long)response.size());
        this.verifyRelationships(response);
    }

    private void verifyRelationships(List<Map<String, Object>> response) {
        for (Map<String, Object> relMap : response) {
            RelationshipRepresentationTest.verifySerialisation(relMap);
        }
    }

    @Test
    public void shouldHandleSets() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithSet");
        List<String> strings = Arrays.asList("aaa", "bbb", "aaa");
        Map params = MapUtil.map((Object[])new Object[]{"strings", strings});
        PluginFunctionalTestHelper.makePostMap(methodUri, params);
        HashSet<String> stringsSet = new HashSet<String>(strings);
        Assert.assertThat(FunctionalTestPlugin.stringSet, (Matcher)CoreMatchers.is(stringsSet));
    }

    @Test
    public void shouldHandleJsonLists() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithList");
        List<String> strings = Arrays.asList("aaa", "bbb", "aaa");
        Map params = MapUtil.map((Object[])new Object[]{"strings", strings});
        PluginFunctionalTestHelper.makePostMap(methodUri, params);
        ArrayList<String> stringsList = new ArrayList<String>(strings);
        Assert.assertThat(FunctionalTestPlugin.stringList, (Matcher)CoreMatchers.is(stringsList));
    }

    @Test
    public void shouldHandleUrlEncodedLists() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithList");
        String postBody = "strings[]=aaa&strings[]=bbb&strings[]=ccc";
        RestRequest.req().post(methodUri, postBody, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        List<String> strings = Arrays.asList("aaa", "bbb", "ccc");
        ArrayList<String> stringsList = new ArrayList<String>(strings);
        Assert.assertThat(FunctionalTestPlugin.stringList, (Matcher)CoreMatchers.is(stringsList));
    }

    @Test
    public void shouldHandleUrlEncodedListsAndInt() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithListAndInt");
        String postBody = "strings[]=aaa&strings[]=bbb&strings[]=ccc&count=3";
        RestRequest.req().post(methodUri, postBody, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        List<String> strings = Arrays.asList("aaa", "bbb", "ccc");
        ArrayList<String> stringsList = new ArrayList<String>(strings);
        Assert.assertThat(FunctionalTestPlugin.stringList, (Matcher)CoreMatchers.is(stringsList));
        Assert.assertThat((Object)FunctionalTestPlugin._integer, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void shouldHandleArrays() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithArray");
        String[] stringArray = new String[]{"aaa", "bbb", "aaa"};
        List<String> strings = Arrays.asList(stringArray);
        Map params = MapUtil.map((Object[])new Object[]{"strings", strings});
        PluginFunctionalTestHelper.makePostMap(methodUri, params);
        Assert.assertThat((Object)FunctionalTestPlugin.stringArray, (Matcher)CoreMatchers.is((Object)stringArray));
    }

    @Test
    public void shouldHandlePrimitiveArrays() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithIntArray");
        Integer[] intArray = new Integer[]{5, 6, 7, 8};
        List<Integer> ints = Arrays.asList(intArray);
        Map params = MapUtil.map((Object[])new Object[]{"ints", ints});
        PluginFunctionalTestHelper.makePostMap(methodUri, params);
        Assert.assertThat((Object)FunctionalTestPlugin.intArray, (Matcher)CoreMatchers.is((Object)new int[]{5, 6, 7, 8}));
    }

    @Test
    public void shouldHandleOptionalArrays() throws Exception {
        String methodUri = this.getPluginMethodUri(functionalTestHelper.dataUri(), "methodWithOptionalArray");
        PluginFunctionalTestHelper.makePostMap(methodUri);
        Assert.assertThat((Object)FunctionalTestPlugin.intArray, (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldBeAbleToReturnPaths() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        long r = functionalTestHelper.getGraphDbHelper().getFirstNode();
        functionalTestHelper.getGraphDbHelper().createRelationship("friend", n, r);
        String methodUri = this.getPluginMethodUri(functionalTestHelper.nodeUri(n), "pathToReference");
        Map<String, Object> maps = PluginFunctionalTestHelper.makePostMap(methodUri);
        Assert.assertThat((Object)((String)maps.get("start")), (Matcher)CoreMatchers.endsWith((String)Long.toString(r)));
        Assert.assertThat((Object)((String)maps.get("end")), (Matcher)CoreMatchers.endsWith((String)Long.toString(n)));
    }

    @Test
    public void shouldHandleNullPath() throws Exception {
        long n = functionalTestHelper.getGraphDbHelper().createNode(new Label[0]);
        String url = this.getPluginMethodUri(functionalTestHelper.nodeUri(n), "pathToReference");
        JaxRsResponse response = new RestRequest().post(url, null);
        Assert.assertThat((String)response.getEntity(), (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)204));
        response.close();
    }
}

