/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.plugins.FunctionalTestPlugin;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.server.SharedServerTestBase;

public class ExtensionListingFunctionalTestIT
extends SharedServerTestBase {
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(SharedServerTestBase.server());
    }

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase((NeoServer)SharedServerTestBase.server());
    }

    @Test
    public void datarootContainsReferenceToExtensions() throws Exception {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.dataUri());
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        Map json = JsonHelper.jsonToMap((String)response.getEntity());
        String extInfo = (String)json.get("extensions_info");
        Assert.assertNotNull((Object)new URI(extInfo));
        response.close();
    }

    @Test
    public void canListAllAvailableServerExtensions() throws Exception {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.extensionUri());
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        Map json = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertFalse((boolean)json.isEmpty());
        response.close();
    }

    @Test
    public void canListExtensionMethodsForServerExtension() throws Exception {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.extensionUri());
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        Map json = JsonHelper.jsonToMap((String)response.getEntity());
        String refNodeService = (String)json.get(FunctionalTestPlugin.class.getSimpleName());
        response.close();
        response = RestRequest.req().get(refNodeService);
        String result = response.getEntity();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        json = JsonHelper.jsonToMap((String)result);
        json = (Map)json.get("graphdb");
        Assert.assertThat((Object)json, (Matcher)Matchers.hasKey((Object)"createNode"));
        response.close();
    }
}

