/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class UnsafeUtilTest {
    @Test
    public void mustHaveUnsafe() throws Exception {
        UnsafeUtil.assertHasUnsafe();
    }

    @Test
    public void pageSizeIsPowerOfTwo() throws Exception {
        Assert.assertThat((Object)UnsafeUtil.pageSize(), (Matcher)Matchers.isOneOf((Object[])new Integer[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000}));
    }

    @Test
    public void mustSupportReadingFromAndWritingToFields() throws Exception {
        long aBooleanOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aBoolean");
        Obj obj = new Obj();
        UnsafeUtil.putBoolean((Object)obj, (long)aBooleanOffset, (boolean)true);
        Assert.assertThat((Object)obj.aBoolean, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)UnsafeUtil.getBoolean((Object)obj, (long)aBooleanOffset), (Matcher)Matchers.is((Object)true));
        obj.aBoolean = false;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putBooleanVolatile((Object)obj, (long)aBooleanOffset, (boolean)true);
        Assert.assertThat((Object)obj.aBoolean, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)UnsafeUtil.getBooleanVolatile((Object)obj, (long)aBooleanOffset), (Matcher)Matchers.is((Object)true));
        obj.aBoolean = false;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long aByteOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aByte");
        obj = new Obj();
        UnsafeUtil.putByte((Object)obj, (long)aByteOffset, (byte)1);
        Assert.assertThat((Object)obj.aByte, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)UnsafeUtil.getByte((Object)obj, (long)aByteOffset), (Matcher)Matchers.is((Object)1));
        obj.aByte = 0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putByteVolatile((Object)obj, (long)aByteOffset, (byte)2);
        Assert.assertThat((Object)obj.aByte, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)UnsafeUtil.getByteVolatile((Object)obj, (long)aByteOffset), (Matcher)Matchers.is((Object)2));
        obj.aByte = 0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long aShortOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aShort");
        obj = new Obj();
        UnsafeUtil.putShort((Object)obj, (long)aShortOffset, (short)1);
        Assert.assertThat((Object)obj.aShort, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)UnsafeUtil.getShort((Object)obj, (long)aShortOffset), (Matcher)Matchers.is((Object)1));
        obj.aShort = 0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putShortVolatile((Object)obj, (long)aShortOffset, (short)2);
        Assert.assertThat((Object)obj.aShort, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)UnsafeUtil.getShortVolatile((Object)obj, (long)aShortOffset), (Matcher)Matchers.is((Object)2));
        obj.aShort = 0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long aFloatOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aFloat");
        obj = new Obj();
        UnsafeUtil.putFloat((Object)obj, (long)aFloatOffset, (float)1.0f);
        Assert.assertThat((Object)Float.valueOf(obj.aFloat), (Matcher)Matchers.is((Object)Float.valueOf(1.0f)));
        Assert.assertThat((Object)Float.valueOf(UnsafeUtil.getFloat((Object)obj, (long)aFloatOffset)), (Matcher)Matchers.is((Object)Float.valueOf(1.0f)));
        obj.aFloat = 0.0f;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putFloatVolatile((Object)obj, (long)aFloatOffset, (float)2.0f);
        Assert.assertThat((Object)Float.valueOf(obj.aFloat), (Matcher)Matchers.is((Object)Float.valueOf(2.0f)));
        Assert.assertThat((Object)Float.valueOf(UnsafeUtil.getFloatVolatile((Object)obj, (long)aFloatOffset)), (Matcher)Matchers.is((Object)Float.valueOf(2.0f)));
        obj.aFloat = 0.0f;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long aCharOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aChar");
        obj = new Obj();
        UnsafeUtil.putChar((Object)obj, (long)aCharOffset, (char)'1');
        Assert.assertThat((Object)Character.valueOf(obj.aChar), (Matcher)Matchers.is((Object)Character.valueOf('1')));
        Assert.assertThat((Object)Character.valueOf(UnsafeUtil.getChar((Object)obj, (long)aCharOffset)), (Matcher)Matchers.is((Object)Character.valueOf('1')));
        obj.aChar = '\u0000';
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putCharVolatile((Object)obj, (long)aCharOffset, (char)'2');
        Assert.assertThat((Object)Character.valueOf(obj.aChar), (Matcher)Matchers.is((Object)Character.valueOf('2')));
        Assert.assertThat((Object)Character.valueOf(UnsafeUtil.getCharVolatile((Object)obj, (long)aCharOffset)), (Matcher)Matchers.is((Object)Character.valueOf('2')));
        obj.aChar = '\u0000';
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long anIntOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"anInt");
        obj = new Obj();
        UnsafeUtil.putInt((Object)obj, (long)anIntOffset, (int)1);
        Assert.assertThat((Object)obj.anInt, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)UnsafeUtil.getInt((Object)obj, (long)anIntOffset), (Matcher)Matchers.is((Object)1));
        obj.anInt = 0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putIntVolatile((Object)obj, (long)anIntOffset, (int)2);
        Assert.assertThat((Object)obj.anInt, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)UnsafeUtil.getIntVolatile((Object)obj, (long)anIntOffset), (Matcher)Matchers.is((Object)2));
        obj.anInt = 0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long aLongOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aLong");
        obj = new Obj();
        UnsafeUtil.putLong((Object)obj, (long)aLongOffset, (long)1L);
        Assert.assertThat((Object)obj.aLong, (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)UnsafeUtil.getLong((Object)obj, (long)aLongOffset), (Matcher)Matchers.is((Object)1L));
        obj.aLong = 0L;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putLongVolatile((Object)obj, (long)aLongOffset, (long)2L);
        Assert.assertThat((Object)obj.aLong, (Matcher)Matchers.is((Object)2L));
        Assert.assertThat((Object)UnsafeUtil.getLongVolatile((Object)obj, (long)aLongOffset), (Matcher)Matchers.is((Object)2L));
        obj.aLong = 0L;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long aDoubleOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aDouble");
        obj = new Obj();
        UnsafeUtil.putDouble((Object)obj, (long)aDoubleOffset, (double)1.0);
        Assert.assertThat((Object)obj.aDouble, (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)UnsafeUtil.getDouble((Object)obj, (long)aDoubleOffset), (Matcher)Matchers.is((Object)1.0));
        obj.aDouble = 0.0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putDoubleVolatile((Object)obj, (long)aDoubleOffset, (double)2.0);
        Assert.assertThat((Object)obj.aDouble, (Matcher)Matchers.is((Object)2.0));
        Assert.assertThat((Object)UnsafeUtil.getDoubleVolatile((Object)obj, (long)aDoubleOffset), (Matcher)Matchers.is((Object)2.0));
        obj.aDouble = 0.0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        long objectOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"object");
        obj = new Obj();
        Object a = new Object();
        Object b = new Object();
        UnsafeUtil.putObject((Object)obj, (long)objectOffset, (Object)a);
        Assert.assertThat((Object)obj.object, (Matcher)Matchers.is((Object)a));
        Assert.assertThat((Object)UnsafeUtil.getObject((Object)obj, (long)objectOffset), (Matcher)Matchers.is((Object)a));
        obj.object = null;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
        UnsafeUtil.putObjectVolatile((Object)obj, (long)objectOffset, (Object)b);
        Assert.assertThat((Object)obj.object, (Matcher)Matchers.is((Object)b));
        Assert.assertThat((Object)UnsafeUtil.getObjectVolatile((Object)obj, (long)objectOffset), (Matcher)Matchers.is((Object)b));
        obj.object = null;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
    }

    @Test
    public void mustSupportReadingAndWritingOfPrimitivesToMemory() throws Exception {
        long address = UnsafeUtil.allocateMemory((long)8L);
        try {
            UnsafeUtil.putByte((long)address, (byte)1);
            Assert.assertThat((Object)UnsafeUtil.getByte((long)address), (Matcher)Matchers.is((Object)1));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getByte((long)address), (Matcher)Matchers.is((Object)0));
            UnsafeUtil.putByteVolatile((long)address, (byte)1);
            Assert.assertThat((Object)UnsafeUtil.getByteVolatile((long)address), (Matcher)Matchers.is((Object)1));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getByteVolatile((long)address), (Matcher)Matchers.is((Object)0));
            UnsafeUtil.putShort((long)address, (short)1);
            Assert.assertThat((Object)UnsafeUtil.getShort((long)address), (Matcher)Matchers.is((Object)1));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getShort((long)address), (Matcher)Matchers.is((Object)0));
            UnsafeUtil.putShortVolatile((long)address, (short)1);
            Assert.assertThat((Object)UnsafeUtil.getShortVolatile((long)address), (Matcher)Matchers.is((Object)1));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getShortVolatile((long)address), (Matcher)Matchers.is((Object)0));
            UnsafeUtil.putFloat((long)address, (float)1.0f);
            Assert.assertThat((Object)Float.valueOf(UnsafeUtil.getFloat((long)address)), (Matcher)Matchers.is((Object)Float.valueOf(1.0f)));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)Float.valueOf(UnsafeUtil.getFloat((long)address)), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
            UnsafeUtil.putFloatVolatile((long)address, (float)1.0f);
            Assert.assertThat((Object)Float.valueOf(UnsafeUtil.getFloatVolatile((long)address)), (Matcher)Matchers.is((Object)Float.valueOf(1.0f)));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)Float.valueOf(UnsafeUtil.getFloatVolatile((long)address)), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
            UnsafeUtil.putChar((long)address, (char)'1');
            Assert.assertThat((Object)Character.valueOf(UnsafeUtil.getChar((long)address)), (Matcher)Matchers.is((Object)Character.valueOf('1')));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)Character.valueOf(UnsafeUtil.getChar((long)address)), (Matcher)Matchers.is((Object)Character.valueOf('\u0000')));
            UnsafeUtil.putCharVolatile((long)address, (char)'1');
            Assert.assertThat((Object)Character.valueOf(UnsafeUtil.getCharVolatile((long)address)), (Matcher)Matchers.is((Object)Character.valueOf('1')));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)Character.valueOf(UnsafeUtil.getCharVolatile((long)address)), (Matcher)Matchers.is((Object)Character.valueOf('\u0000')));
            UnsafeUtil.putInt((long)address, (int)1);
            Assert.assertThat((Object)UnsafeUtil.getInt((long)address), (Matcher)Matchers.is((Object)1));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getInt((long)address), (Matcher)Matchers.is((Object)0));
            UnsafeUtil.putIntVolatile((long)address, (int)1);
            Assert.assertThat((Object)UnsafeUtil.getIntVolatile((long)address), (Matcher)Matchers.is((Object)1));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getIntVolatile((long)address), (Matcher)Matchers.is((Object)0));
            UnsafeUtil.putLong((long)address, (long)1L);
            Assert.assertThat((Object)UnsafeUtil.getLong((long)address), (Matcher)Matchers.is((Object)1L));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getLong((long)address), (Matcher)Matchers.is((Object)0L));
            UnsafeUtil.putLongVolatile((long)address, (long)1L);
            Assert.assertThat((Object)UnsafeUtil.getLongVolatile((long)address), (Matcher)Matchers.is((Object)1L));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getLongVolatile((long)address), (Matcher)Matchers.is((Object)0L));
            UnsafeUtil.putDouble((long)address, (double)1.0);
            Assert.assertThat((Object)UnsafeUtil.getDouble((long)address), (Matcher)Matchers.is((Object)1.0));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getDouble((long)address), (Matcher)Matchers.is((Object)0.0));
            UnsafeUtil.putDoubleVolatile((long)address, (double)1.0);
            Assert.assertThat((Object)UnsafeUtil.getDoubleVolatile((long)address), (Matcher)Matchers.is((Object)1.0));
            UnsafeUtil.setMemory((long)address, (long)8L, (byte)0);
            Assert.assertThat((Object)UnsafeUtil.getDoubleVolatile((long)address), (Matcher)Matchers.is((Object)0.0));
        }
        finally {
            UnsafeUtil.free((long)address);
        }
    }

    @Test
    public void getAndAddIntOfField() throws Exception {
        Obj obj = new Obj();
        long anIntOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"anInt");
        Assert.assertThat((Object)UnsafeUtil.getAndAddInt((Object)obj, (long)anIntOffset, (int)3), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)UnsafeUtil.getAndAddInt((Object)obj, (long)anIntOffset, (int)2), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)obj.anInt, (Matcher)Matchers.is((Object)5));
        obj.anInt = 0;
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
    }

    @Test
    public void compareAndSwapLongField() throws Exception {
        Obj obj = new Obj();
        long aLongOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"aLong");
        Assert.assertTrue((boolean)UnsafeUtil.compareAndSwapLong((Object)obj, (long)aLongOffset, (long)0L, (long)5L));
        Assert.assertFalse((boolean)UnsafeUtil.compareAndSwapLong((Object)obj, (long)aLongOffset, (long)0L, (long)5L));
        Assert.assertTrue((boolean)UnsafeUtil.compareAndSwapLong((Object)obj, (long)aLongOffset, (long)5L, (long)0L));
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
    }

    @Test
    public void compareAndSwapObjectField() throws Exception {
        Obj obj = new Obj();
        long objectOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"object");
        Assert.assertTrue((boolean)UnsafeUtil.compareAndSwapObject((Object)obj, (long)objectOffset, null, (Object)obj));
        Assert.assertFalse((boolean)UnsafeUtil.compareAndSwapObject((Object)obj, (long)objectOffset, null, (Object)obj));
        Assert.assertTrue((boolean)UnsafeUtil.compareAndSwapObject((Object)obj, (long)objectOffset, (Object)obj, null));
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
    }

    @Test
    public void getAndSetObjectField() throws Exception {
        Obj obj = new Obj();
        long objectOffset = UnsafeUtil.getFieldOffset(Obj.class, (String)"object");
        Assert.assertThat((Object)UnsafeUtil.getAndSetObject((Object)obj, (long)objectOffset, (Object)obj), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)UnsafeUtil.getAndSetObject((Object)obj, (long)objectOffset, null), (Matcher)Matchers.sameInstance((Object)obj));
        Assert.assertThat((Object)obj, (Matcher)Matchers.is((Object)new Obj()));
    }

    @Test
    public void unsafeArrayElementAccess() throws Exception {
        int len = 3;
        boolean[] booleans = new boolean[len];
        int scale = UnsafeUtil.arrayIndexScale(booleans.getClass());
        int base = UnsafeUtil.arrayBaseOffset(booleans.getClass());
        UnsafeUtil.putBoolean((Object)booleans, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (boolean)true);
        Assert.assertThat((Object)booleans[0], (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)booleans[1], (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)booleans[2], (Matcher)Matchers.is((Object)false));
        byte[] bytes = new byte[len];
        scale = UnsafeUtil.arrayIndexScale(bytes.getClass());
        base = UnsafeUtil.arrayBaseOffset(bytes.getClass());
        UnsafeUtil.putByte((Object)bytes, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (byte)-1);
        Assert.assertThat((Object)bytes[0], (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)bytes[1], (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)bytes[2], (Matcher)Matchers.is((Object)0));
        short[] shorts = new short[len];
        scale = UnsafeUtil.arrayIndexScale(shorts.getClass());
        base = UnsafeUtil.arrayBaseOffset(shorts.getClass());
        UnsafeUtil.putShort((Object)shorts, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (short)-1);
        Assert.assertThat((Object)shorts[0], (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)shorts[1], (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)shorts[2], (Matcher)Matchers.is((Object)0));
        float[] floats = new float[len];
        scale = UnsafeUtil.arrayIndexScale(floats.getClass());
        base = UnsafeUtil.arrayBaseOffset(floats.getClass());
        UnsafeUtil.putFloat((Object)floats, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (float)-1.0f);
        Assert.assertThat((Object)Float.valueOf(floats[0]), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
        Assert.assertThat((Object)Float.valueOf(floats[1]), (Matcher)Matchers.is((Object)Float.valueOf(-1.0f)));
        Assert.assertThat((Object)Float.valueOf(floats[2]), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
        char[] chars = new char[len];
        scale = UnsafeUtil.arrayIndexScale(chars.getClass());
        base = UnsafeUtil.arrayBaseOffset(chars.getClass());
        UnsafeUtil.putChar((Object)chars, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (char)'\uffff');
        Assert.assertThat((Object)Character.valueOf(chars[0]), (Matcher)Matchers.is((Object)Character.valueOf('\u0000')));
        Assert.assertThat((Object)Character.valueOf(chars[1]), (Matcher)Matchers.is((Object)Character.valueOf('\uffff')));
        Assert.assertThat((Object)Character.valueOf(chars[2]), (Matcher)Matchers.is((Object)Character.valueOf('\u0000')));
        int[] ints = new int[len];
        scale = UnsafeUtil.arrayIndexScale(ints.getClass());
        base = UnsafeUtil.arrayBaseOffset(ints.getClass());
        UnsafeUtil.putInt((Object)ints, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (int)-1);
        Assert.assertThat((Object)ints[0], (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)ints[1], (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)ints[2], (Matcher)Matchers.is((Object)0));
        long[] longs = new long[len];
        scale = UnsafeUtil.arrayIndexScale(longs.getClass());
        base = UnsafeUtil.arrayBaseOffset(longs.getClass());
        UnsafeUtil.putLong((Object)longs, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (long)-1L);
        Assert.assertThat((Object)longs[0], (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)longs[1], (Matcher)Matchers.is((Object)-1L));
        Assert.assertThat((Object)longs[2], (Matcher)Matchers.is((Object)0L));
        double[] doubles = new double[len];
        scale = UnsafeUtil.arrayIndexScale(doubles.getClass());
        base = UnsafeUtil.arrayBaseOffset(doubles.getClass());
        UnsafeUtil.putDouble((Object)doubles, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (double)-1.0);
        Assert.assertThat((Object)doubles[0], (Matcher)Matchers.is((Object)0.0));
        Assert.assertThat((Object)doubles[1], (Matcher)Matchers.is((Object)-1.0));
        Assert.assertThat((Object)doubles[2], (Matcher)Matchers.is((Object)0.0));
        Object[] objects = new Object[len];
        scale = UnsafeUtil.arrayIndexScale(objects.getClass());
        base = UnsafeUtil.arrayBaseOffset(objects.getClass());
        UnsafeUtil.putObject((Object)objects, (long)UnsafeUtil.arrayOffset((int)1, (int)base, (int)scale), (Object)objects);
        Assert.assertThat((Object)objects[0], (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)objects[1], (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)objects)));
        Assert.assertThat((Object)objects[2], (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void directByteBufferCreationAndInitialisation() throws Exception {
        long address = UnsafeUtil.allocateMemory((long)313L);
        try {
            UnsafeUtil.setMemory((long)address, (long)313L, (byte)0);
            ByteBuffer a = UnsafeUtil.newDirectByteBuffer((long)address, (int)313);
            Assert.assertThat((Object)a, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)UnsafeUtil.newDirectByteBuffer((long)address, (int)313)))));
            Assert.assertThat((Object)a.hasArray(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)a.isDirect(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)a.capacity(), (Matcher)Matchers.is((Object)313));
            Assert.assertThat((Object)a.limit(), (Matcher)Matchers.is((Object)313));
            Assert.assertThat((Object)a.position(), (Matcher)Matchers.is((Object)0));
            Assert.assertThat((Object)a.remaining(), (Matcher)Matchers.is((Object)313));
            Assert.assertThat((Object)UnsafeUtil.getByte((long)address), (Matcher)Matchers.is((Object)0));
            a.put((byte)-1);
            Assert.assertThat((Object)UnsafeUtil.getByte((long)address), (Matcher)Matchers.is((Object)-1));
            a.position(101);
            a.mark();
            a.limit(202);
            long address2 = UnsafeUtil.allocateMemory((long)424L);
            try {
                UnsafeUtil.setMemory((long)address2, (long)424L, (byte)0);
                UnsafeUtil.initDirectByteBuffer((Object)a, (long)address2, (int)424);
                Assert.assertThat((Object)a.hasArray(), (Matcher)Matchers.is((Object)false));
                Assert.assertThat((Object)a.isDirect(), (Matcher)Matchers.is((Object)true));
                Assert.assertThat((Object)a.capacity(), (Matcher)Matchers.is((Object)424));
                Assert.assertThat((Object)a.limit(), (Matcher)Matchers.is((Object)424));
                Assert.assertThat((Object)a.position(), (Matcher)Matchers.is((Object)0));
                Assert.assertThat((Object)a.remaining(), (Matcher)Matchers.is((Object)424));
                Assert.assertThat((Object)UnsafeUtil.getByte((long)address2), (Matcher)Matchers.is((Object)0));
                a.put((byte)-1);
                Assert.assertThat((Object)UnsafeUtil.getByte((long)address2), (Matcher)Matchers.is((Object)-1));
            }
            finally {
                UnsafeUtil.free((long)address2);
            }
        }
        finally {
            UnsafeUtil.free((long)address);
        }
    }

    @Test
    public void shouldAlignMemoryTo4ByteBoundary() throws Exception {
        long allocatedMemory = System.currentTimeMillis();
        int alignBy = 4;
        for (int i = 0; i < 10; ++i) {
            long alignedMemory = UnsafeUtil.alignedMemory((long)allocatedMemory, (int)alignBy);
            Assert.assertTrue((alignedMemory >= allocatedMemory ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)(alignedMemory % 4L));
            Assert.assertTrue((alignedMemory - allocatedMemory <= 3L ? 1 : 0) != 0);
            ++allocatedMemory;
        }
    }

    @Test
    public void shouldPutAndGetByteWiseLittleEndianShort() throws Exception {
        long p = UnsafeUtil.allocateMemory((long)2L);
        short value = -13142;
        UnsafeUtil.putShortByteWiseLittleEndian((long)p, (short)value);
        short readValue = UnsafeUtil.getShortByteWiseLittleEndian((long)p);
        UnsafeUtil.free((long)p);
        Assert.assertEquals((long)value, (long)readValue);
    }

    @Test
    public void shouldPutAndGetByteWiseLittleEndianInt() throws Exception {
        long p = UnsafeUtil.allocateMemory((long)4L);
        int value = -861234842;
        UnsafeUtil.putIntByteWiseLittleEndian((long)p, (int)value);
        int readValue = UnsafeUtil.getIntByteWiseLittleEndian((long)p);
        UnsafeUtil.free((long)p);
        Assert.assertEquals((long)value, (long)readValue);
    }

    @Test
    public void shouldPutAndGetByteWiseLittleEndianLong() throws Exception {
        long p = UnsafeUtil.allocateMemory((long)8L);
        long value = -3698975478279560687L;
        UnsafeUtil.putLongByteWiseLittleEndian((long)p, (long)value);
        long readValue = UnsafeUtil.getLongByteWiseLittleEndian((long)p);
        UnsafeUtil.free((long)p);
        Assert.assertEquals((long)value, (long)readValue);
    }

    class Obj {
        boolean aBoolean;
        byte aByte;
        short aShort;
        float aFloat;
        char aChar;
        int anInt;
        long aLong;
        double aDouble;
        Object object;

        Obj() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Obj obj = (Obj)o;
            return this.aBoolean == obj.aBoolean && this.aByte == obj.aByte && this.aShort == obj.aShort && Float.compare(obj.aFloat, this.aFloat) == 0 && this.aChar == obj.aChar && this.anInt == obj.anInt && this.aLong == obj.aLong && Double.compare(obj.aDouble, this.aDouble) == 0 && Objects.equals(this.object, obj.object);
        }

        public int hashCode() {
            return Objects.hash(this.aBoolean, this.aByte, this.aShort, Float.valueOf(this.aFloat), Character.valueOf(this.aChar), this.anInt, this.aLong, this.aDouble, this.object);
        }
    }
}

