/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class TestSslCertificateFactory {
    @Inject
    private TestDirectory testDirectory;

    TestSslCertificateFactory() {
    }

    @Test
    void shouldCreateASelfSignedCertificate() throws Exception {
        PkiUtils sslFactory = new PkiUtils();
        File cPath = new File(this.testDirectory.directory(), "certificate");
        File pkPath = new File(this.testDirectory.directory(), "key");
        sslFactory.createSelfSignedCertificate(cPath, pkPath, "myhost");
        X509Certificate[] certificates = sslFactory.loadCertificates(cPath);
        MatcherAssert.assertThat((Object)certificates.length, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        PrivateKey pk = sslFactory.loadPrivateKey(pkPath);
        MatcherAssert.assertThat((Object)pk, (Matcher)Matchers.notNullValue());
    }

    @Test
    void shouldLoadPEMCertificates() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File pemCertificate = cert.certificate();
        X509Certificate[] certificates = certs.loadCertificates(pemCertificate);
        MatcherAssert.assertThat((Object)certificates.length, (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    void shouldLoadPEMPrivateKey() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File privateKey = cert.privateKey();
        PrivateKey pk = certs.loadPrivateKey(privateKey);
        Assertions.assertNotNull((Object)pk);
    }

    @Test
    void shouldLoadBinaryCertificates() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File cPath = this.testDirectory.file("certificate");
        Assertions.assertTrue((boolean)cPath.createNewFile());
        byte[] raw = certs.loadCertificates(cert.certificate())[0].getEncoded();
        try (FileChannel ch = FileChannel.open(cPath.toPath(), StandardOpenOption.WRITE);){
            FileUtils.writeAll((FileChannel)ch, (ByteBuffer)ByteBuffer.wrap(raw));
        }
        X509Certificate[] certificates = certs.loadCertificates(cPath);
        MatcherAssert.assertThat((Object)certificates.length, (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    void shouldLoadBinaryPrivateKey() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File keyFile = this.testDirectory.file("certificate");
        Assertions.assertTrue((boolean)keyFile.createNewFile());
        byte[] raw = certs.loadPrivateKey(cert.privateKey()).getEncoded();
        try (FileChannel ch = FileChannel.open(keyFile.toPath(), StandardOpenOption.WRITE);){
            FileUtils.writeAll((FileChannel)ch, (ByteBuffer)ByteBuffer.wrap(raw));
        }
        PrivateKey pk = certs.loadPrivateKey(keyFile);
        Assertions.assertNotNull((Object)pk);
    }
}

