/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.ssl.SslResource;

public class SslResourceBuilder {
    private static final String CA_CERTIFICATE_NAME = "cluster.crt";
    private static final String PRIVATE_KEY_NAME = "private.key";
    private static final String PUBLIC_CERT_NAME = "public.crt";
    private static final String SELF_SIGNED_NAME = "selfsigned.crt";
    private static final String REVOKED_NAME = "revoked.crl";
    private static final String CA_SIGNED_NAME = "casigned.crt";
    private static final String TRUSTED_DIR_NAME = "trusted";
    private static final String REVOKED_DIR_NAME = "revoked";
    private static final String CA_BASE_PATH = "test-certificates/ca/";
    private static final String SERVERS_BASE_PATH = "test-certificates/servers/";
    private final int keyId;
    private final SignedBy signedBy;
    private boolean trustSignedByCA;
    private Set<Integer> trusted = new HashSet<Integer>();
    private Set<Integer> revoked = new HashSet<Integer>();
    private FileSystemAbstraction fsa = new DefaultFileSystemAbstraction();

    private SslResourceBuilder(int keyId, SignedBy signedBy) {
        this.keyId = keyId;
        this.signedBy = signedBy;
    }

    public static SslResourceBuilder selfSignedKeyId(int keyId) {
        return new SslResourceBuilder(keyId, SignedBy.SELF);
    }

    public static SslResourceBuilder caSignedKeyId(int keyId) {
        return new SslResourceBuilder(keyId, SignedBy.CA);
    }

    public SslResourceBuilder trustKeyId(int keyId) {
        this.trusted.add(keyId);
        return this;
    }

    public SslResourceBuilder trustSignedByCA() {
        this.trustSignedByCA = true;
        return this;
    }

    public SslResourceBuilder revoke(int keyId) {
        this.revoked.add(keyId);
        return this;
    }

    public SslResource install(File targetDirectory) throws IOException {
        File targetKey = new File(targetDirectory, PRIVATE_KEY_NAME);
        File targetCertificate = new File(targetDirectory, PUBLIC_CERT_NAME);
        File targetTrusted = new File(targetDirectory, TRUSTED_DIR_NAME);
        File targetRevoked = new File(targetDirectory, REVOKED_DIR_NAME);
        this.fsa.mkdir(targetTrusted);
        this.fsa.mkdir(targetRevoked);
        for (int trustedKeyId : this.trusted) {
            File targetTrustedCertificate = new File(targetTrusted, String.valueOf(trustedKeyId) + ".crt");
            this.copy(SslResourceBuilder.resource(SELF_SIGNED_NAME, trustedKeyId), targetTrustedCertificate);
        }
        for (int revokedKeyId : this.revoked) {
            File targetRevokedCRL = new File(targetRevoked, String.valueOf(revokedKeyId) + ".crl");
            this.copy(SslResourceBuilder.resource(REVOKED_NAME, revokedKeyId), targetRevokedCRL);
        }
        if (this.trustSignedByCA) {
            File targetTrustedCertificate = new File(targetTrusted, CA_CERTIFICATE_NAME);
            this.copy(this.resource(CA_CERTIFICATE_NAME), targetTrustedCertificate);
        }
        this.copy(SslResourceBuilder.resource(PRIVATE_KEY_NAME, this.keyId), targetKey);
        this.copy(this.signedBy.keyId(this.keyId), targetCertificate);
        return new SslResource(targetKey, targetCertificate, targetTrusted, targetRevoked);
    }

    private static URL resource(String filename, int keyId) {
        return SslResourceBuilder.class.getResource(SERVERS_BASE_PATH + String.valueOf(keyId) + "/" + filename);
    }

    private URL resource(String filename) {
        return SslResourceBuilder.class.getResource(CA_BASE_PATH + filename);
    }

    private void copy(URL in, File outFile) throws IOException {
        try (InputStream is = in.openStream();
             OutputStream os = this.fsa.openAsOutputStream(outFile, false);){
            while (is.available() > 0) {
                byte[] buf = new byte[8192];
                int nBytes = is.read(buf);
                os.write(buf, 0, nBytes);
            }
        }
    }

    static enum SignedBy {
        SELF("selfsigned.crt"),
        CA("casigned.crt");

        private final String resourceName;

        private SignedBy(String resourceName) {
            this.resourceName = resourceName;
        }

        public URL keyId(int keyId) {
            return SslResourceBuilder.resource(this.resourceName, keyId);
        }
    }
}

