/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.io.File;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.ssl.KeyStoreFactory;
import org.neo4j.ssl.KeyStoreInformation;
import org.neo4j.ssl.PkiUtils;

public class KeyStoreFactoryTest {
    @Rule
    public TemporaryFolder dir = new TemporaryFolder();

    @Test
    public void shouldCreateKeyStoreForGivenKeyPair() throws Exception {
        File certificatePath = new File(this.dir.getRoot(), "cert");
        File privateKeyPath = new File(this.dir.getRoot(), "key");
        new PkiUtils().createSelfSignedCertificate(certificatePath, privateKeyPath, "some-hostname");
        KeyStoreInformation ks = new KeyStoreFactory().createKeyStore(privateKeyPath, certificatePath);
        Assert.assertNotNull((Object)ks.getKeyStore());
    }

    @Test
    public void shouldImportSingleCertificateWhenNotInAChain() throws Exception {
        File certificatePath = new File(this.dir.getRoot(), "cert");
        File privateKeyPath = new File(this.dir.getRoot(), "key");
        new PkiUtils().createSelfSignedCertificate(certificatePath, privateKeyPath, "some-hostname");
        KeyStoreInformation keyStoreInformation = new KeyStoreFactory().createKeyStore(privateKeyPath, certificatePath);
        KeyStore keyStore = keyStoreInformation.getKeyStore();
        Certificate[] chain = keyStore.getCertificateChain("key");
        Assert.assertEquals((String)("Single certificate expected not a chain of [" + chain.length + "]"), (long)1L, (long)chain.length);
    }

    @Test
    public void shouldImportAllCertificatesInAChain() throws Exception {
        File privateKeyPath = this.fileFromResources("test-certificates/chained_key.der");
        File certificatePath = this.fileFromResources("test-certificates/combined.pem");
        KeyStoreInformation keyStoreInformation = new KeyStoreFactory().createKeyStore(privateKeyPath, certificatePath);
        KeyStore keyStore = keyStoreInformation.getKeyStore();
        Certificate[] chain = keyStore.getCertificateChain("key");
        Assert.assertEquals((String)"3 certificates expected in chain: root, intermediary, and user's", (long)3L, (long)chain.length);
    }

    private File fileFromResources(String path) {
        URL url = this.getClass().getResource(path);
        return new File(url.getFile());
    }
}

