/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.ssl.PkiUtils;

public class TestSslCertificateFactory {
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    @Test
    public void shouldCreateASelfSignedCertificate() throws Exception {
        PkiUtils sslFactory = new PkiUtils();
        File cPath = new File(this.tmpDir.getRoot(), "certificate");
        File pkPath = new File(this.tmpDir.getRoot(), "key");
        sslFactory.createSelfSignedCertificate(cPath, pkPath, "myhost");
        X509Certificate[] certificates = sslFactory.loadCertificates(cPath);
        Assert.assertThat((Object)certificates.length, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        PrivateKey pk = sslFactory.loadPrivateKey(pkPath);
        Assert.assertThat((Object)pk, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void shouldLoadPEMCertificates() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File pemCertificate = cert.certificate();
        X509Certificate[] certificates = certs.loadCertificates(pemCertificate);
        Assert.assertThat((Object)certificates.length, (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldLoadPEMPrivateKey() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File privateKey = cert.privateKey();
        PrivateKey pk = certs.loadPrivateKey(privateKey);
        Assert.assertNotNull((Object)pk);
    }

    @Test
    public void shouldLoadBinaryCertificates() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File cPath = this.tmpDir.newFile("certificate");
        byte[] raw = certs.loadCertificates(cert.certificate())[0].getEncoded();
        try (FileChannel ch = FileChannel.open(cPath.toPath(), StandardOpenOption.WRITE);){
            FileUtils.writeAll((FileChannel)ch, (ByteBuffer)ByteBuffer.wrap(raw));
        }
        X509Certificate[] certificates = certs.loadCertificates(cPath);
        Assert.assertThat((Object)certificates.length, (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldLoadBinaryPrivateKey() throws Throwable {
        SelfSignedCertificate cert = new SelfSignedCertificate("example.com");
        PkiUtils certs = new PkiUtils();
        File keyFile = this.tmpDir.newFile("certificate");
        byte[] raw = certs.loadPrivateKey(cert.privateKey()).getEncoded();
        try (FileChannel ch = FileChannel.open(keyFile.toPath(), StandardOpenOption.WRITE);){
            FileUtils.writeAll((FileChannel)ch, (ByteBuffer)ByteBuffer.wrap(raw));
        }
        PrivateKey pk = certs.loadPrivateKey(keyFile);
        Assert.assertNotNull((Object)pk);
    }
}

