/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.gis.spatial.index.Envelope;

class EnvelopeTest {
    EnvelopeTest() {
    }

    @Test
    void shouldCreateBasic2DEnvelopes() {
        for (double width = 0.0; width < 10.0; width += 2.5) {
            for (double minx = -10.0; minx < 10.0; minx += 2.5) {
                for (double miny = -10.0; miny < 10.0; miny += 2.5) {
                    double maxx = minx + width;
                    double maxy = miny + width;
                    EnvelopeTest.makeAndTestEnvelope(new double[]{minx, miny}, new double[]{maxx, maxy}, new double[]{width, width});
                }
            }
        }
    }

    @Test
    void shouldHandleIntersectionsIn1D() {
        double widthX = 1.0;
        double widthY = 1.0;
        Envelope left = new Envelope(0.0, widthX, 0.0, widthY);
        for (double minx = -10.0; minx < 10.0; minx += 0.2) {
            double maxx = minx + widthX;
            Envelope right = new Envelope(minx, maxx, 0.0, widthY);
            if (maxx < left.getMinX() || minx > left.getMaxX()) {
                EnvelopeTest.testDoesNotOverlap(left, right);
                continue;
            }
            double overlapX = maxx < left.getMaxX() ? maxx - left.getMinX() : left.getMaxX() - minx;
            double overlap = overlapX * widthY;
            EnvelopeTest.testOverlaps(left, right, true, overlap);
        }
    }

    @Test
    void shouldHandleIntersectionsIn2D() {
        Envelope left = new Envelope(0.0, 1.0, 0.0, 1.0);
        EnvelopeTest.testOverlaps(left, new Envelope(0.0, 1.0, 0.0, 1.0), true, 1.0, 1.0);
        EnvelopeTest.testOverlaps(left, new Envelope(0.5, 1.0, 0.5, 1.0), true, 1.0, 0.25);
        EnvelopeTest.testOverlaps(left, new Envelope(0.25, 0.75, 0.25, 0.75), true, 1.0, 0.25);
        EnvelopeTest.testOverlaps(left, new Envelope(-0.5, 0.5, -0.5, 0.5), true, 0.25, 0.25);
        EnvelopeTest.testOverlaps(left, new Envelope(-0.5, 1.5, -0.5, 1.5), true, 1.0, 1.0);
        EnvelopeTest.testOverlaps(left, new Envelope(-1.0, 0.0, 0.0, 1.0), true, 0.0, 0.0);
        EnvelopeTest.testOverlaps(left, new Envelope(0.5, 1.5, 1.0, 2.0), true, 0.0, 0.0);
        EnvelopeTest.testOverlaps(left, new Envelope(0.5, 1.5, 0.0, 1.0), true, 0.5, 0.5);
    }

    @Test
    void testWithSideRatioNotTooSmall2D() {
        double[] from = new double[]{0.0, 0.0};
        double[] to = new double[]{1.0, 1.0};
        Envelope envelope = new Envelope(from, to).withSideRatioNotTooSmall();
        double[] expectedFrom = new double[]{0.0, 0.0};
        double[] expectedTo = new double[]{1.0, 1.0};
        Assertions.assertArrayEquals((double[])expectedFrom, (double[])envelope.min, (double)1.0E-4);
        Assertions.assertArrayEquals((double[])expectedTo, (double[])envelope.max, (double)1.0E-4);
        double bigValue = 100.0;
        double smallValue = 1.0E-18;
        to = new double[]{100.0, 1.0E-18};
        Envelope envelope2 = new Envelope(from, to).withSideRatioNotTooSmall();
        double[] expectedTo2 = new double[]{100.0, 0.001};
        Assertions.assertArrayEquals((double[])expectedFrom, (double[])envelope2.min, (double)1.0E-4);
        Assertions.assertArrayEquals((double[])expectedTo2, (double[])envelope2.max, (double)1.0E-5);
    }

    @Test
    void testWithSideRatioNotTooSmall4D() {
        double[] from = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] to = new double[]{1.0, 1.0, 1.0, 1.0};
        Envelope envelope = new Envelope(from, to).withSideRatioNotTooSmall();
        double[] expectedFrom = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] expectedTo = new double[]{1.0, 1.0, 1.0, 1.0};
        Assertions.assertArrayEquals((double[])expectedFrom, (double[])envelope.min, (double)1.0E-4);
        Assertions.assertArrayEquals((double[])expectedTo, (double[])envelope.max, (double)1.0E-4);
        double bigValue = 107.0;
        double smallValue = 1.23E-18;
        to = new double[]{107.0, 1.23E-18, 12.0, 1.2300000000000001E-19};
        Envelope envelope2 = new Envelope(from, to).withSideRatioNotTooSmall();
        double[] expectedTo2 = new double[]{107.0, 0.00107, 12.0, 0.00107};
        Assertions.assertArrayEquals((double[])expectedFrom, (double[])envelope2.min, (double)1.0E-5);
        Assertions.assertArrayEquals((double[])expectedTo2, (double[])envelope2.max, (double)1.0E-5);
    }

    private static void makeAndTestEnvelope(double[] min, double[] max, double[] width) {
        Envelope env = new Envelope(min, max);
        MatcherAssert.assertThat((String)"Expected min-x to be correct", (Object)env.getMinX(), (Matcher)Matchers.equalTo((Object)min[0]));
        MatcherAssert.assertThat((String)"Expected min-y to be correct", (Object)env.getMinY(), (Matcher)Matchers.equalTo((Object)min[1]));
        MatcherAssert.assertThat((String)"Expected max-x to be correct", (Object)env.getMaxX(), (Matcher)Matchers.equalTo((Object)max[0]));
        MatcherAssert.assertThat((String)"Expected max-y to be correct", (Object)env.getMaxY(), (Matcher)Matchers.equalTo((Object)max[1]));
        MatcherAssert.assertThat((String)"Expected dimension to be same as min.length", (Object)env.getDimension(), (Matcher)Matchers.equalTo((Object)min.length));
        MatcherAssert.assertThat((String)"Expected dimension to be same as max.length", (Object)env.getDimension(), (Matcher)Matchers.equalTo((Object)max.length));
        for (int i = 0; i < min.length; ++i) {
            MatcherAssert.assertThat((String)("Expected min[" + i + "] to be correct"), (Object)env.getMin(i), (Matcher)Matchers.equalTo((Object)min[i]));
            MatcherAssert.assertThat((String)("Expected max[" + i + "] to be correct"), (Object)env.getMax(i), (Matcher)Matchers.equalTo((Object)max[i]));
        }
        double area = 1.0;
        Envelope copy = new Envelope(env);
        Envelope intersection = env.intersection(copy);
        for (int i = 0; i < min.length; ++i) {
            MatcherAssert.assertThat((String)("Expected width[" + i + "] to be correct"), (Object)env.getWidth(i), (Matcher)Matchers.equalTo((Object)width[i]));
            MatcherAssert.assertThat((String)("Expected copied width[" + i + "] to be correct"), (Object)copy.getWidth(i), (Matcher)Matchers.equalTo((Object)width[i]));
            MatcherAssert.assertThat((String)("Expected intersected width[" + i + "] to be correct"), (Object)intersection.getWidth(i), (Matcher)Matchers.equalTo((Object)width[i]));
            area *= width[i];
        }
        MatcherAssert.assertThat((String)"Expected area to be correct", (Object)env.getArea(), (Matcher)Matchers.equalTo((Object)area));
        MatcherAssert.assertThat((String)"Expected copied area to be correct", (Object)env.getArea(), (Matcher)Matchers.equalTo((Object)copy.getArea()));
        MatcherAssert.assertThat((String)"Expected intersected area to be correct", (Object)env.getArea(), (Matcher)Matchers.equalTo((Object)intersection.getArea()));
        Assertions.assertTrue((boolean)env.intersects(copy), (String)"Expected copied envelope to intersect");
        MatcherAssert.assertThat((String)"Expected copied envelope to intersect completely", (Object)env.overlap(copy), (Matcher)Matchers.equalTo((Object)1.0));
    }

    private static void testDoesNotOverlap(Envelope left, Envelope right) {
        Envelope bbox = new Envelope(left);
        bbox.expandToInclude(right);
        EnvelopeTest.testOverlaps(left, right, false, 0.0);
    }

    private static void testOverlaps(Envelope left, Envelope right, boolean intersects, double overlap) {
        String intersectMessage = intersects ? "Should intersect" : "Should not intersect";
        String overlapMessage = intersects ? "Should overlap" : "Should not have overlap";
        MatcherAssert.assertThat((String)intersectMessage, (Object)left.intersects(right), (Matcher)Matchers.equalTo((Object)intersects));
        MatcherAssert.assertThat((String)intersectMessage, (Object)right.intersects(left), (Matcher)Matchers.equalTo((Object)intersects));
        MatcherAssert.assertThat((String)overlapMessage, (Object)left.overlap(right), (Matcher)Matchers.closeTo((double)overlap, (double)1.0E-6));
        MatcherAssert.assertThat((String)overlapMessage, (Object)right.overlap(left), (Matcher)Matchers.closeTo((double)overlap, (double)1.0E-6));
    }

    private static void testOverlaps(Envelope left, Envelope right, boolean intersects, double overlap, double overlapArea) {
        EnvelopeTest.testOverlaps(left, right, intersects, overlap);
        MatcherAssert.assertThat((String)"Expected overlap area", (Object)left.intersection(right).getArea(), (Matcher)Matchers.closeTo((double)overlapArea, (double)1.0E-6));
        MatcherAssert.assertThat((String)"Expected overlap area", (Object)right.intersection(left).getArea(), (Matcher)Matchers.closeTo((double)overlapArea, (double)1.0E-6));
    }
}

