/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.AppShellServer;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.SilentLocalOutput;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.Cd;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class CdTest {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();
    private final Output silence = new SilentLocalOutput();
    private final Session session = new Session((Serializable)((Object)"test"));
    private GraphDatabaseAPI db;
    private GraphDatabaseShellServer server;

    @Before
    public void setup() throws Exception {
        this.db = this.dbRule.getGraphDatabaseAPI();
        this.server = new GraphDatabaseShellServer(this.db);
        this.session.set("TITLE_KEYS", (Object)"name");
    }

    @After
    public void shutdown() throws Exception {
        this.server.shutdown();
    }

    @Test
    public void shouldProvideTabCompletions() throws Exception {
        Node root = this.createNodeWithSomeSubNodes("Mattias", "Magnus", "Tobias");
        Cd app = (Cd)this.server.findApp("cd");
        app.execute(new AppCommandParser((AppShellServer)this.server, "cd -a " + root.getId()), this.session, this.silence);
        List candidates = app.completionCandidates("cd Ma", this.session);
        this.assertHasCandidate(candidates, "Mattias");
        this.assertHasCandidate(candidates, "Magnus");
    }

    private void assertHasCandidate(List<String> candidates, String shouldStartWith) {
        boolean found = false;
        for (String candidate : candidates) {
            if (!candidate.startsWith(shouldStartWith)) continue;
            found = true;
        }
        Assert.assertTrue((String)("Should have found a candidate among " + candidates + " starting with '" + shouldStartWith + "'"), (boolean)found);
    }

    private Node createNodeWithSomeSubNodes(String ... names) {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Node root = db.createNode();
            for (String name : names) {
                Node node = db.createNode();
                node.setProperty("name", (Object)name);
                root.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            tx.success();
            Node node = root;
            return node;
        }
    }
}

