/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractClient;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

public class ClientIT {
    @Test
    public void shouldHandleNormalInput() throws ShellException, RemoteException {
        final CollectingOutput output = new CollectingOutput();
        String message = "Test method called";
        AbstractClient client = new AbstractClient(null, null){

            public ShellServer getServer() {
                GraphDatabaseShellServer server = null;
                try {
                    server = new GraphDatabaseShellServer(null){

                        public Response interpretLine(Serializable clientId, String line, Output out) {
                            try {
                                out.println((Serializable)((Object)"Test method called"));
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            return new Response("", Continuation.INPUT_COMPLETE);
                        }
                    };
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return server;
            }

            public Output getOutput() {
                return output;
            }
        };
        client.evaluate("RETURN 1;");
        HashSet<String> messages = new HashSet<String>();
        for (String s : output) {
            messages.add(s);
        }
        Assert.assertThat(messages, (Matcher)Matchers.contains((Object[])new String[]{"Test method called"}));
    }

    @Test
    public void shouldExitMultilineModeAfterGettingWarningOrError() throws ShellException, RemoteException {
        final CollectingOutput output = new CollectingOutput();
        String message = "Test method called";
        String prompt = "our test prompt";
        AbstractClient client = new AbstractClient(null, null){

            public ShellServer getServer() {
                GraphDatabaseShellServer server = null;
                try {
                    server = new GraphDatabaseShellServer(null){

                        public Response interpretLine(Serializable clientId, String line, Output out) {
                            try {
                                out.println((Serializable)((Object)"Test method called"));
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            return new Response("our test prompt", line.endsWith(";") ? Continuation.EXCEPTION_CAUGHT : Continuation.INPUT_INCOMPLETE);
                        }
                    };
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return server;
            }

            public Output getOutput() {
                return output;
            }
        };
        client.evaluate("RETURN ");
        Assert.assertThat((Object)client.getPrompt(), (Matcher)CoreMatchers.equalTo((Object)"> "));
        client.evaluate("i;");
        HashSet<String> messages = new HashSet<String>();
        for (String s : output) {
            messages.add(s);
        }
        Assert.assertThat(messages, (Matcher)Matchers.contains((Object[])new String[]{"Test method called"}));
        Assert.assertThat((Object)client.getPrompt(), (Matcher)CoreMatchers.equalTo((Object)"our test prompt"));
    }
}

