/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.shell.FakeShellServer;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestTransactionApps {
    protected GraphDatabaseAPI db;
    private FakeShellServer shellServer;
    private ShellClient shellClient;

    @Before
    public void doBefore() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.shellServer = new FakeShellServer(this.db);
        this.shellClient = new SameJvmClient(new HashMap(), (ShellServer)this.shellServer, (Output)new CollectingOutput());
    }

    @After
    public void doAfter() throws Exception {
        this.shellClient.shutdown();
        this.shellServer.shutdown();
        this.db.shutdown();
    }

    @Test
    public void begin_transaction_opens_a_transaction() throws Exception {
        this.executeCommand("begin transaction", new String[0]);
        this.assertWeAreInATransaction();
    }

    @Test
    public void two_begin_tran_works_as_expected() throws Exception {
        this.executeCommand("begin tran", new String[0]);
        this.executeCommand("begin transaction", new String[0]);
        this.assertWeAreInATransaction();
    }

    @Test
    public void multiple_begins_and_commits_work() throws Exception {
        this.executeCommand("begin transaction", new String[0]);
        this.executeCommand("begin", new String[0]);
        this.executeCommand("begin transaction", new String[0]);
        this.executeCommand("commit", new String[0]);
        this.executeCommand("commit", new String[0]);
        this.executeCommand("commit", new String[0]);
        this.assertWeAreNotInATransaction();
    }

    @Test
    public void commit_tran_closes_open_transaction() throws Exception {
        this.executeCommand("begin transaction", new String[0]);
        this.executeCommand("commit", new String[0]);
        this.assertWeAreNotInATransaction();
    }

    @Test
    public void already_in_transaction() throws Exception {
        this.db.beginTx();
        this.executeCommand("begin transaction", new String[0]);
        this.executeCommand("commit", new String[0]);
        this.assertWeAreInATransaction();
    }

    @Test
    public void rollback_rolls_everything_back() throws Exception {
        this.db.beginTx();
        this.executeCommand("begin transaction", new String[0]);
        this.executeCommand("begin transaction", new String[0]);
        this.executeCommand("begin transaction", new String[0]);
        this.executeCommand("rollback", new String[0]);
        this.assertWeAreNotInATransaction();
    }

    @Test
    public void rollback_outside_of_transaction_fails() throws Exception {
        this.executeCommandExpectingException("rollback", "Not in a transaction");
    }

    private void assertWeAreNotInATransaction() {
        Assert.assertTrue((String)"Expected to not be in a transaction", (this.shellServer.getActiveTransactionCount() == 0 ? 1 : 0) != 0);
    }

    private void assertWeAreInATransaction() {
        Assert.assertTrue((String)"Expected to be in a transaction", (this.shellServer.getActiveTransactionCount() > 0 ? 1 : 0) != 0);
    }

    public void executeCommand(String command, String ... theseLinesMustExistRegEx) throws Exception {
        this.executeCommand(this.shellClient, command, theseLinesMustExistRegEx);
    }

    public void executeCommand(ShellClient client, String command, String ... theseLinesMustExistRegEx) throws Exception {
        CollectingOutput output = new CollectingOutput();
        client.evaluate(command, (Output)output);
        for (String lineThatMustExist : theseLinesMustExistRegEx) {
            boolean negative = lineThatMustExist.startsWith("!");
            lineThatMustExist = negative ? lineThatMustExist.substring(1) : lineThatMustExist;
            Pattern pattern = Pattern.compile(lineThatMustExist);
            boolean found = false;
            for (String line : output) {
                if (!pattern.matcher(line).find()) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Was expecting a line matching '" + lineThatMustExist + "', but didn't find any from out of " + Iterables.asCollection((Iterable)output)), (found != negative ? 1 : 0) != 0);
        }
    }

    public void executeCommandExpectingException(String command, String errorMessageShouldContain) throws Exception {
        block2: {
            CollectingOutput output = new CollectingOutput();
            try {
                this.shellClient.evaluate(command, (Output)output);
                Assert.fail((String)"Was expecting an exception");
            }
            catch (ShellException e) {
                String errorMessage = e.getMessage();
                if (errorMessage.toLowerCase().contains(errorMessageShouldContain.toLowerCase())) break block2;
                Assert.fail((String)("Error message '" + errorMessage + "' should have contained '" + errorMessageShouldContain + "'"));
            }
        }
    }
}

