/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltServer;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.shell.AbstractShellIT;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.StartClient;
import org.neo4j.shell.Welcome;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;

public class StartClientIT
extends AbstractShellIT {
    @Rule
    public SuppressOutput mute = SuppressOutput.suppressAll();
    private GraphDatabaseShellServer shellServer;

    @Before
    public void startDatabase() {
        this.makeServerRemotelyAvailable();
    }

    @Test
    public void givenShellClientWhenOpenFileThenExecuteFileCommands() {
        StartClient.main((String[])new String[]{"-file", this.getClass().getResource("/testshell.txt").getFile()});
        this.assertNodeExists("testshell_foo", "testshell_bar");
    }

    @Test
    public void givenShellClientWhenReadFromStdinThenExecutePipedCommands() {
        InputStream realStdin = System.in;
        try {
            System.setIn(new ByteArrayInputStream("CREATE (n {stdin_foo:'stdin_bar'});".getBytes()));
            StartClient.main((String[])new String[]{"-file", "-"});
        }
        finally {
            System.setIn(realStdin);
        }
        this.assertNodeExists("stdin_foo", "stdin_bar");
    }

    @Test
    public void mustWarnWhenRunningScriptWithUnterminatedMultilineCommands() {
        String script = this.getClass().getResource("/unterminated-cypher-query.txt").getFile();
        String output = this.runAndCaptureOutput(new String[]{"-file", script});
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Warning: Exiting with unterminated multi-line input."));
    }

    @Test
    public void mustNotAboutExitingWithUnterminatedCommandWhenItIsNothingButComments() {
        String script = this.getClass().getResource("/unterminated-comment.txt").getFile();
        String output = this.runAndCaptureOutput(new String[]{"-file", script});
        Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"Warning: Exiting with unterminated multi-line input.")));
    }

    @Test
    public void testShellCloseAfterCommandExecution() throws Exception {
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        CtrlCHandler ctrlCHandler = (CtrlCHandler)Mockito.mock(CtrlCHandler.class);
        final GraphDatabaseShellServer databaseShellServer = (GraphDatabaseShellServer)Mockito.mock(GraphDatabaseShellServer.class);
        Mockito.when((Object)databaseShellServer.welcome((Map)ArgumentMatchers.any())).thenReturn((Object)new Welcome("", (Serializable)Integer.valueOf(1), ""));
        Mockito.when((Object)databaseShellServer.interpretLine((Serializable)ArgumentMatchers.any(Serializable.class), (String)ArgumentMatchers.any(String.class), (Output)ArgumentMatchers.any(Output.class))).thenReturn((Object)new Response("", Continuation.INPUT_COMPLETE));
        StartClient startClient = new StartClient(out, err){

            protected GraphDatabaseShellServer getGraphDatabaseShellServer(File path, boolean readOnly, String configFile) {
                return databaseShellServer;
            }
        };
        startClient.start(new String[]{"-path", this.db.databaseDirectory().getAbsolutePath(), "-c", "CREATE (n {foo:'bar'});"}, ctrlCHandler);
        ((GraphDatabaseShellServer)Mockito.verify((Object)databaseShellServer)).shutdown();
    }

    @Test
    public void shouldReportEditionThroughDbInfoApp() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        CtrlCHandler ctrlCHandler = (CtrlCHandler)Mockito.mock(CtrlCHandler.class);
        StartClient client = new StartClient(new PrintStream(out), new PrintStream(err));
        client.start(new String[]{"-path", this.db.databaseDirectory().getAbsolutePath() + "testDb", "-c", "dbinfo -g Configuration unsupported.dbms.edition"}, ctrlCHandler);
        Assert.assertEquals((long)0L, (long)err.size());
        Assert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"\"unsupported.dbms.edition\": \"community\""));
    }

    @Test
    public void shouldPrintVersionAndExit() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        CtrlCHandler ctrlCHandler = (CtrlCHandler)Mockito.mock(CtrlCHandler.class);
        StartClient client = new StartClient(new PrintStream(out), new PrintStream(err));
        client.start(new String[]{"-version"}, ctrlCHandler);
        Assert.assertEquals((long)0L, (long)err.size());
        String version = out.toString();
        Assert.assertThat((Object)version, (Matcher)CoreMatchers.startsWith((String)"Neo4j Community, version "));
    }

    @Test
    public void shouldNotStartBolt() throws IOException {
        final AssertableLogProvider log = new AssertableLogProvider();
        new StartClient(System.out, System.err){

            protected GraphDatabaseShellServer getGraphDatabaseShellServer(File path, boolean readOnly, String configFile) throws RemoteException {
                TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory().setUserLogProvider((LogProvider)log);
                StartClientIT.this.shellServer = new GraphDatabaseShellServer((GraphDatabaseFactory)factory, path, readOnly, configFile);
                return StartClientIT.this.shellServer;
            }
        }.start(new String[]{"-c", "RETURN 1;", "-path", this.db.databaseDirectory().getAbsolutePath() + "test-db", "-config", this.getClass().getResource("/config-with-bolt-connector.conf").getFile()}, (CtrlCHandler)Mockito.mock(CtrlCHandler.class));
        try {
            log.assertNone(AssertableLogProvider.inLog((Matcher)CoreMatchers.startsWith((String)BoltServer.class.getPackage().getName())).any());
        }
        finally {
            if (this.shellServer != null) {
                this.shellServer.shutdown();
            }
        }
    }

    private void assertNodeExists(String property, Object value) {
        try (Transaction tx = this.db.beginTx();){
            Result result = this.db.execute("MATCH (n {" + property + ": $value}) RETURN count(n) AS res", Collections.singletonMap("value", value));
            long count = (Long)((Object)((Map)Iterators.single((Iterator)result)).getOrDefault("res", 0));
            Assert.assertEquals((long)1L, (long)count);
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runAndCaptureOutput(String[] arguments) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buf);
        PrintStream oldOut = System.out;
        System.setOut(out);
        try {
            StartClient.main((String[])arguments);
            out.close();
            String string = buf.toString();
            return string;
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

