/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.shell.AbstractShellIT;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.SilentLocalOutput;

public class ServerClientInteractionIT
extends AbstractShellIT {
    private SilentLocalOutput out = new SilentLocalOutput();

    @Before
    public void setup() {
        this.makeServerRemotelyAvailable();
    }

    @Test
    public void shouldConsiderAndInterpretCustomClientPrompt() throws Exception {
        this.shellClient.setSessionVariable("PS1", (Serializable)((Object)"MyPrompt \\d \\t$ "));
        Response response = this.shellServer.interpretLine(this.shellClient.getId(), "", (Output)this.out);
        String regexPattern = "MyPrompt .{1,3} .{1,3} \\d{1,2} \\d{2}:\\d{2}:\\d{2}\\$";
        Assert.assertTrue((String)("Prompt from server '" + response.getPrompt() + "' didn't match pattern '" + regexPattern + "'"), (boolean)Pattern.compile(regexPattern).matcher(response.getPrompt()).find());
    }
}

