/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.shell.Output;
import org.neo4j.shell.OutputAsWriter;
import org.neo4j.shell.impl.SystemOutput;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.rule.SuppressOutput;

@ExtendWith(value={SuppressOutputExtension.class})
class OutputAsWriterTest {
    @Inject
    private SuppressOutput suppressOutput;
    private OutputAsWriter writer;

    OutputAsWriterTest() {
    }

    @BeforeEach
    void setUp() {
        this.writer = new OutputAsWriter((Output)new SystemOutput());
    }

    @Test
    void shouldNotFlushWithoutNewline() throws Exception {
        this.writer.write("foo".toCharArray());
        MatcherAssert.assertThat((Object)this.suppressOutput.getOutputVoice().toString(), (Matcher)Matchers.isEmptyString());
    }

    @Test
    void shouldFlushWithNewline() throws Exception {
        SuppressOutput.Voice outputVoice = this.suppressOutput.getOutputVoice();
        String s = String.format("foobar%n", new Object[0]);
        this.writer.write(s.toCharArray());
        Assertions.assertEquals((int)s.length(), (int)OutputAsWriterTest.outpuLengthInBytes(outputVoice));
        Assertions.assertEquals((Object)s, (Object)outputVoice.toString());
    }

    @Test
    void shouldFlushPartiallyWithNewlineInMiddle() throws Exception {
        SuppressOutput.Voice outputVoice = this.suppressOutput.getOutputVoice();
        String firstPart = String.format("foo%n", new Object[0]);
        String secondPart = "bar";
        String string = firstPart + secondPart;
        String newLine = String.format("%n", new Object[0]);
        String fullString = string + newLine;
        this.writer.write(string.toCharArray());
        String firstLine = (String)outputVoice.lines().get(0);
        Assertions.assertNotNull((Object)firstLine);
        Assertions.assertEquals((int)firstPart.length(), (int)OutputAsWriterTest.outpuLengthInBytes(outputVoice));
        Assertions.assertEquals((Object)"foo", (Object)firstLine);
        this.writer.write(newLine.toCharArray());
        String secondLine = (String)outputVoice.lines().get(1);
        Assertions.assertNotNull((Object)secondLine);
        Assertions.assertEquals((int)fullString.length(), (int)OutputAsWriterTest.outpuLengthInBytes(outputVoice));
        Assertions.assertEquals((Object)fullString, (Object)outputVoice.toString());
    }

    private static int outpuLengthInBytes(SuppressOutput.Voice outputVoice) {
        return outputVoice.toString().getBytes().length;
    }
}

