/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.shell.AbstractShellIT;
import org.neo4j.shell.StartClient;
import org.neo4j.test.rule.SuppressOutput;

public class ErrorsAndWarningsIT
extends AbstractShellIT {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Before
    public void setup() {
        this.makeServerRemotelyAvailable();
    }

    @Test
    public void unsupportedQueryShouldBeSilent() {
        InputStream realStdin = System.in;
        try {
            System.setIn(new ByteArrayInputStream("CYPHER planner=cost CREATE ();".getBytes()));
            StartClient.main((String[])new String[]{"-file", "-"});
            String output = this.suppressOutput.getOutputVoice().toString();
            Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
            Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"Using COST planner is unsupported for this query, please use RULE planner instead")));
        }
        finally {
            System.setIn(realStdin);
        }
    }
}

