/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.rmi.RemoteException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Cancelable;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.FakeShellServer;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractClient;
import org.neo4j.shell.impl.CollectingOutput;

public class CtrlCTest {
    @Test
    public void shouldInstallProvidedHandlerAfterReadingUserInput() {
        final StubCtrlCHandler handler = new StubCtrlCHandler();
        AbstractClient client = new AbstractClient(new HashMap(), handler){

            public ShellServer getServer() {
                try {
                    return new FakeShellServer(null);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }

            public Output getOutput() {
                try {
                    return new CollectingOutput();
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }

            public String readLine(String ignored) {
                Assert.assertFalse((String)"handler installed, expected it to not be there", (boolean)handler.installed);
                return "CYPHER 2.1 RETURN 42;";
            }

            public void evaluate(String output) {
                Assert.assertTrue((String)"handler not installed, but expected to be there", (boolean)handler.installed);
                this.end();
            }
        };
        client.grabPrompt();
        Assert.assertFalse((String)"handler installed, expected it to not be there", (boolean)handler.installed);
    }

    public class StubCtrlCHandler
    implements CtrlCHandler {
        public volatile boolean installed;

        public Cancelable install(Runnable action) {
            this.installed = true;
            return () -> {
                this.installed = false;
            };
        }
    }
}

