/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.TestGraphDatabaseFactory;

public class ConfigurationIT {
    private GraphDatabaseAPI db;
    private ShellServer server;
    private ShellClient client;

    @Before
    public void before() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().newGraphDatabase();
        this.server = new GraphDatabaseShellServer(this.db);
        this.client = ShellLobby.newClient((ShellServer)this.server, (CtrlCHandler)InterruptSignalHandler.getHandler());
    }

    @After
    public void after() throws Exception {
        this.client.shutdown();
        this.server.shutdown();
        this.db.shutdown();
    }

    @Test
    public void deprecatedConfigName() throws Exception {
        CollectingOutput output = new CollectingOutput();
        this.client.evaluate("pwd", (Output)output);
        Assert.assertTrue((boolean)output.asString().contains("(?)"));
    }
}

