/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.shell.AbstractShellIT;
import org.neo4j.shell.ShellClient;

public class ClientReconnectIT
extends AbstractShellIT {
    @Before
    public void setUp() {
        this.makeServerRemotelyAvailable();
    }

    @Test
    public void remoteClientAbleToReconnectAndContinue() throws Exception {
        ShellClient client = this.newRemoteClient();
        this.executeCommand(client, "help", "Available commands");
        int serverPort = this.remotelyAvailableOnPort;
        this.restartServer();
        this.makeRemoveAvailableOnPort(serverPort);
        this.executeCommand(client, "help", "Available commands");
        client.shutdown();
    }

    @Test
    public void initialSessionValuesSurvivesReconnect() throws Exception {
        this.createRelationshipChain(2);
        Map initialSession = MapUtil.genericMap((Object[])new Object[]{"TITLE_KEYS", "test"});
        ShellClient client = this.newRemoteClient(initialSession);
        String name = "MyTest";
        client.evaluate("mknode --cd");
        client.evaluate("set test " + name);
        Assert.assertTrue((boolean)client.getPrompt().contains(name));
        client.shutdown();
    }

    private void makeRemoveAvailableOnPort(int serverPort) {
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (true) {
            try {
                this.shellServer.makeRemotelyAvailable(serverPort, "shell");
                return;
            }
            catch (Throwable throwable) {
                if (System.currentTimeMillis() < deadline) continue;
                throw new RuntimeException("Not able to start shell server on desired port for more then 30 seconds.");
            }
            break;
        }
    }
}

