/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.TextUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MappingResourceIterator;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.impl.RelationshipToNodeIterable;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;
import org.neo4j.shell.kernel.apps.TypedId;

public class Cd
extends TransactionProvidingApp {
    private static final String START_ALIAS = "start";
    private static final String END_ALIAS = "end";

    public Cd() {
        this.addOptionDefinition("a", new OptionDefinition(OptionValueType.NONE, "Absolute id, new primitive doesn't need to be connected to the current one"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.NONE, "Makes the supplied id represent a relationship instead of a node"));
    }

    @Override
    public String getDescription() {
        return "Changes the current node or relationship, i.e. traverses one step to another node or relationship. Usage: cd <id>";
    }

    @Override
    protected List<String> completionCandidatesInTx(String partOfLine, Session session) throws ShellException {
        NodeOrRelationship current;
        String lastWord = TextUtil.lastWordOrQuoteOf((String)partOfLine, (boolean)false);
        if (lastWord.startsWith("-")) {
            return super.completionCandidates(partOfLine, session);
        }
        try {
            current = this.getCurrent(session);
        }
        catch (ShellException e) {
            return Collections.emptyList();
        }
        TreeSet<String> result = new TreeSet<String>();
        if (current.isNode()) {
            Node node = current.asNode();
            try (MappingResourceIterator<Node, Relationship> mappingResourceIterator = RelationshipToNodeIterable.wrap((ResourceIterable<Relationship>)Iterables.asResourceIterable((Iterable)node.getRelationships()), node);){
                while (mappingResourceIterator.hasNext()) {
                    Node otherNode = (Node)mappingResourceIterator.next();
                    long otherNodeId = otherNode.getId();
                    String title = Cd.findTitle(session, otherNode);
                    if (title != null && !result.contains(title)) {
                        Cd.maybeAddCompletionCandidate(result, title + "," + otherNodeId, lastWord);
                    }
                    Cd.maybeAddCompletionCandidate(result, "" + otherNodeId, lastWord);
                }
            }
        } else {
            Cd.maybeAddCompletionCandidate(result, START_ALIAS, lastWord);
            Cd.maybeAddCompletionCandidate(result, END_ALIAS, lastWord);
            Relationship rel = current.asRelationship();
            Cd.maybeAddCompletionCandidate(result, "" + rel.getStartNode().getId(), lastWord);
            Cd.maybeAddCompletionCandidate(result, "" + rel.getEndNode().getId(), lastWord);
        }
        return new ArrayList<String>(result);
    }

    private static void maybeAddCompletionCandidate(Collection<String> candidates, String candidate, String lastWord) {
        if (lastWord.length() == 0 || candidate.startsWith(lastWord)) {
            candidates.add(candidate);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException {
        paths = Cd.readCurrentWorkingDir(session);
        newThing = null;
        if (parser.arguments().isEmpty()) {
            Cd.clearCurrent(session);
            Cd.writeCurrentWorkingDir(paths, session);
            return Continuation.INPUT_COMPLETE;
        }
        current = null;
        try {
            current = this.getCurrent(session);
        }
        catch (ShellException var7_7) {
            // empty catch block
        }
        arg = parser.arguments().get(0);
        newId = null;
        var9_10 = arg;
        var10_11 = -1;
        switch (var9_10.hashCode()) {
            case 1472: {
                if (!var9_10.equals("..")) break;
                var10_11 = 0;
                break;
            }
            case 46: {
                if (!var9_10.equals(".")) break;
                var10_11 = 1;
                break;
            }
            case 109757538: {
                if (!var9_10.equals("start")) break;
                var10_11 = 2;
                break;
            }
            case 100571: {
                if (!var9_10.equals("end")) break;
                var10_11 = 3;
            }
        }
        switch (var10_11) {
            case 0: {
                if (paths.size() <= 0) break;
                newId = paths.remove(paths.size() - 1);
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (current == null) {
                    throw new ShellException("Can't do start or end on a non-existent relationship");
                }
                newId = this.getStartOrEnd(current, arg);
                paths.add(current.getTypedId());
                break;
            }
            default: {
                suppliedId = -1L;
                try {
                    suppliedId = Long.parseLong(arg);
                }
                catch (NumberFormatException e) {
                    if (current != null) {
                        suppliedId = this.findNodeWithTitle(current.asNode(), arg, session);
                    }
                    if (suppliedId != -1L) ** GOTO lbl57
                    throw new ShellException("No connected node with title '" + arg + "'");
                }
lbl57:
                // 2 sources

                v0 = newId = parser.options().containsKey("r") != false ? new TypedId("r", suppliedId) : new TypedId("n", suppliedId);
                if (current != null && newId.equals(current.getTypedId())) {
                    throw new ShellException("Can't cd to where you stand");
                }
                absolute = parser.options().containsKey("a");
                if (!absolute && current != null && !this.isConnected(current, newId)) {
                    throw new ShellException(Cd.getDisplayName(this.getServer(), session, newId, false) + " isn't connected to the current primitive, use -a to force it to go there anyway");
                }
                if (current == null) break;
                paths.add(current.getTypedId());
            }
        }
        v1 = newThing = newId != null ? this.getThingById(newId) : current;
        if (newThing != null) {
            Cd.setCurrent(session, newThing);
        } else {
            Cd.clearCurrent(session);
        }
        Cd.writeCurrentWorkingDir(paths, session);
        return Continuation.INPUT_COMPLETE;
    }

    private long findNodeWithTitle(Node node, String match, Session session) throws ShellException {
        Object[] matchParts = this.splitNodeTitleAndId(match);
        if (matchParts[1] != null) {
            return (Long)matchParts[1];
        }
        String titleMatch = (String)matchParts[0];
        try (MappingResourceIterator<Node, Relationship> mappingResourceIterator = RelationshipToNodeIterable.wrap((ResourceIterable<Relationship>)Iterables.asResourceIterable((Iterable)node.getRelationships()), node);){
            while (mappingResourceIterator.hasNext()) {
                Node otherNode = (Node)mappingResourceIterator.next();
                String title = Cd.findTitle(session, otherNode);
                if (!titleMatch.equals(title)) continue;
                long l = otherNode.getId();
                return l;
            }
        }
        return -1L;
    }

    private Object[] splitNodeTitleAndId(String string) {
        int index = string.lastIndexOf(44);
        String title = null;
        Long id = null;
        try {
            id = Long.parseLong(string.substring(index + 1));
            title = string.substring(0, index);
        }
        catch (NumberFormatException e) {
            title = string;
        }
        return new Object[]{title, id};
    }

    private TypedId getStartOrEnd(NodeOrRelationship current, String arg) throws ShellException {
        if (!current.isRelationship()) {
            throw new ShellException("Only allowed on relationships");
        }
        Node newNode = null;
        switch (arg) {
            case "start": {
                newNode = current.asRelationship().getStartNode();
                break;
            }
            case "end": {
                newNode = current.asRelationship().getEndNode();
                break;
            }
            default: {
                throw new ShellException("Unknown alias '" + arg + "'");
            }
        }
        return NodeOrRelationship.wrap(newNode).getTypedId();
    }

    private boolean isConnected(NodeOrRelationship current, TypedId newId) {
        if (current.isNode()) {
            Node currentNode = current.asNode();
            long startTime = System.currentTimeMillis();
            ResourceIterable relationships = Iterables.asResourceIterable((Iterable)currentNode.getRelationships());
            try (ResourceIterator resourceIterator = relationships.iterator();){
                while (resourceIterator.hasNext()) {
                    Relationship rel = (Relationship)resourceIterator.next();
                    if (newId.isNode()) {
                        if (rel.getOtherNode(currentNode).getId() == newId.getId()) {
                            boolean bl = true;
                            return bl;
                        }
                    } else if (rel.getId() == newId.getId()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (System.currentTimeMillis() - startTime <= 350L) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        if (newId.isRelationship()) {
            return false;
        }
        Relationship relationship = current.asRelationship();
        if (relationship.getStartNode().getId() == newId.getId() || relationship.getEndNode().getId() == newId.getId()) {
            return true;
        }
        return false;
    }
}

