/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;

public class SessionTest {
    private Session session;

    @Before
    public void setUp() throws Exception {
        this.session = new Session((Serializable)Integer.valueOf(1));
    }

    @Test(expected=ShellException.class)
    public void cannotSetInvalidVariableName() throws ShellException {
        this.session.set("foo bar", (Object)42);
    }

    @Test
    public void canSetVariableName() throws ShellException {
        this.session.set("_foobar", (Object)42);
    }

    @Test(expected=ShellException.class)
    public void cannotGetInvalidVariableName() throws ShellException {
        this.session.get("foo bar");
    }

    @Test
    public void canGetVariableName() throws ShellException {
        this.session.set("_foobar", (Object)42);
        Assert.assertEquals((Object)42, (Object)this.session.get("_foobar"));
    }

    @Test(expected=ShellException.class)
    public void cannotRemoveInvalidVariableName() throws ShellException {
        this.session.remove("foo bar");
    }

    @Test
    public void canRemoveVariableName() throws ShellException {
        this.session.set("_foobar", (Object)42);
        Assert.assertEquals((Object)42, (Object)this.session.remove("_foobar"));
    }

    @Test
    public void canCheckInvalidVariableName() throws ShellException {
        Assert.assertEquals((Object)false, (Object)this.session.has("foo bar"));
    }

    @Test
    public void canCheckVariableName() throws ShellException {
        Assert.assertEquals((Object)false, (Object)this.session.has("_foobar"));
        this.session.set("_foobar", (Object)42);
        Assert.assertEquals((Object)true, (Object)this.session.has("_foobar"));
    }
}

