/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.shell.AbstractShellIT;
import org.neo4j.shell.ShellClient;

public class ClientReconnectIT
extends AbstractShellIT {
    @Test
    public void remoteClientAbleToReconnectAndContinue() throws Exception {
        this.makeServerRemotelyAvailable();
        ShellClient client = this.newRemoteClient();
        this.executeCommand(client, "help", "Available commands");
        this.restartServer();
        this.makeServerRemotelyAvailable();
        this.executeCommand(client, "help", "Available commands");
        client.shutdown();
    }

    @Test
    public void initialSessionValuesSurvivesReconnect() throws Exception {
        this.createRelationshipChain(2);
        this.makeServerRemotelyAvailable();
        Map initialSession = MapUtil.genericMap((Object[])new Object[]{"TITLE_KEYS", "test"});
        ShellClient client = this.newRemoteClient(initialSession);
        String name = "MyTest";
        client.evaluate("mknode --cd");
        client.evaluate("set test " + name);
        Assert.assertTrue((boolean)client.getPrompt().contains(name));
        client.shutdown();
    }
}

