/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cypher.NodeStillHasRelationshipsException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.shell.AbstractShellIT;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.StartClient;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.SuppressOutput;

public class AppsIT
extends AbstractShellIT {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void canSetPropertiesAndLsWithFilters() throws Exception {
        RelationshipType type1 = RelationshipType.withName((String)"KNOWS");
        RelationshipType type2 = RelationshipType.withName((String)"LOVES");
        Relationship[] relationships = this.createRelationshipChain(type1, 2);
        Node node = this.getEndNode(relationships[0]);
        this.createRelationshipChain(node, type2, 1);
        this.executeCommand("cd " + node.getId(), new String[0]);
        this.executeCommand("ls", "<-", "->");
        this.executeCommand("ls -p", "!Neo");
        this.setProperty(node, "name", "Neo");
        this.executeCommand("ls -p", "Neo");
        this.executeCommand("ls", "<-", "->", "Neo", type1.name(), type2.name());
        this.executeCommand("ls -r", "<-", "->", "!Neo");
        this.executeCommand("ls -rf .*:out", "!<-", "->", "!Neo", type1.name(), type2.name());
        this.executeCommand("ls -rf .*:in", "<-", "!->", "!Neo", type1.name(), "!" + type2.name());
        this.executeCommand("ls -rf KN.*:in", "<-", "!->", type1.name(), "!" + type2.name());
        this.executeCommand("ls -rf LOVES:in", "!<-", "!->", "!" + type1.name(), "!" + type2.name());
        this.executeCommand("ls -pf something", "!<-", "!->", "!Neo");
        this.executeCommand("ls -pf name", "!<-", "!->", "Neo");
        this.executeCommand("ls -pf name:Something", "!<-", "!->", "!Neo");
        this.executeCommand("ls -pf name:Neo", "!<-", "!->", "Neo");
    }

    @Test
    public void canSetAndRemoveProperties() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(2);
        Node node = this.getEndNode(relationships[0]);
        this.executeCommand("cd " + node.getId(), new String[0]);
        String name = "Mattias";
        this.executeCommand("set name " + name, new String[0]);
        int age = 31;
        this.executeCommand("set age -t int " + age, new String[0]);
        this.executeCommand("set \"some property\" -t long[] \"[1234,5678]", new String[0]);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)name)));
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"age").withValue((Object)age)));
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"some property").withValue((Object)new long[]{1234L, 5678L})));
        this.executeCommand("rm age", new String[0]);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)IsNot.not((Matcher)Neo4jMatchers.hasProperty((String)"age"))));
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)name)));
    }

    @Test
    public void canCreateRelationshipsAndNodes() throws Exception {
        Node thirdNode;
        Relationship thirdRelationship;
        Node node;
        RelationshipType type1 = RelationshipType.withName((String)"type1");
        RelationshipType type2 = RelationshipType.withName((String)"type2");
        RelationshipType type3 = RelationshipType.withName((String)"type3");
        this.executeCommand("mknode --cd", new String[0]);
        this.executeCommandExpectingException("mkrel -c", "type");
        this.executeCommand("mkrel -ct " + type1.name(), new String[0]);
        try (Transaction ignored = this.db.beginTx();){
            Relationship relationship = this.db.getNodeById(0L).getSingleRelationship(type1, Direction.OUTGOING);
            node = relationship.getEndNode();
        }
        this.executeCommand("mkrel -t " + type2.name() + " " + node.getId(), new String[0]);
        ignored = this.db.beginTx();
        var6_5 = null;
        try {
            Relationship otherRelationship = this.db.getNodeById(0L).getSingleRelationship(type2, Direction.OUTGOING);
            Assert.assertEquals((Object)node, (Object)otherRelationship.getEndNode());
        }
        catch (Throwable otherRelationship) {
            var6_5 = otherRelationship;
            throw otherRelationship;
        }
        finally {
            if (ignored != null) {
                if (var6_5 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable otherRelationship) {
                        var6_5.addSuppressed(otherRelationship);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        this.executeCommand("mkrel -ct " + type3.name() + " --np \"{'name':'Neo','destiny':'The one'}\" --rp \"{'number':11}\"", new String[0]);
        try (Transaction ignored = this.db.beginTx();){
            thirdRelationship = this.db.getNodeById(0L).getSingleRelationship(type3, Direction.OUTGOING);
            Assert.assertThat((Object)thirdRelationship, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"number").withValue((Object)11)));
            thirdNode = thirdRelationship.getEndNode();
        }
        Assert.assertThat((Object)thirdNode, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"Neo")));
        Assert.assertThat((Object)thirdNode, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"destiny").withValue((Object)"The one")));
        this.executeCommand("cd -r " + thirdRelationship.getId(), new String[0]);
        this.executeCommand("mv number other-number", new String[0]);
        Assert.assertThat((Object)thirdRelationship, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)IsNot.not((Matcher)Neo4jMatchers.hasProperty((String)"number"))));
        Assert.assertThat((Object)thirdRelationship, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"other-number").withValue((Object)11)));
        this.executeCommand("cd end", new String[0]);
        this.executeCommand("mkrel -ct " + type1.name() + " --np \"{'name':'new'}\" --cd", new String[0]);
        this.executeCommand("ls -p", "name", "new");
    }

    @Test
    public void rmrelCanLeaveStrandedIslands() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(4);
        this.executeCommand("cd -a " + this.getEndNode(relationships[1]).getId(), new String[0]);
        Relationship relToDelete = relationships[2];
        Node otherNode = this.getEndNode(relToDelete);
        this.executeCommand("rmrel -fd " + relToDelete.getId(), new String[0]);
        this.assertRelationshipDoesntExist(relToDelete);
        this.assertNodeExists(otherNode);
    }

    @Test
    public void rmrelCanLeaveStrandedNodes() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(1);
        Node otherNode = this.getEndNode(relationships[0]);
        this.executeCommand("cd 0", new String[0]);
        this.executeCommand("rmrel -f " + relationships[0].getId(), new String[0]);
        this.assertRelationshipDoesntExist(relationships[0]);
        this.assertNodeExists(otherNode);
    }

    @Test
    public void rmrelCanDeleteStrandedNodes() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(1);
        Node otherNode = this.getEndNode(relationships[0]);
        this.executeCommand("cd 0", new String[0]);
        this.executeCommand("rmrel -fd " + relationships[0].getId(), "not having any relationships");
        this.assertRelationshipDoesntExist(relationships[0]);
        this.assertNodeDoesntExist(otherNode);
    }

    @Test
    public void rmrelCanDeleteRelationshipSoThatCurrentNodeGetsStranded() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(2);
        this.executeCommand("cd " + this.getEndNode(relationships[0]).getId(), new String[0]);
        this.deleteRelationship(relationships[0]);
        Node currentNode = this.getStartNode(relationships[1]);
        this.executeCommand("rmrel -fd " + relationships[1].getId(), "not having any relationships");
        this.assertNodeExists(currentNode);
        try (Transaction ignored = this.db.beginTx();){
            Assert.assertFalse((boolean)currentNode.hasRelationship());
        }
    }

    private Node getStartNode(Relationship relationship) {
        this.beginTx();
        try {
            Node node = relationship.getStartNode();
            return node;
        }
        finally {
            this.finishTx(false);
        }
    }

    @Test
    public void rmnodeCanDeleteStrandedNodes() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(1);
        Node strandedNode = this.getEndNode(relationships[0]);
        this.deleteRelationship(relationships[0]);
        this.executeCommand("rmnode " + strandedNode.getId(), new String[0]);
        this.assertNodeDoesntExist(strandedNode);
    }

    @Test
    public void rmnodeCanDeleteConnectedNodes() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(2);
        Node middleNode = this.getEndNode(relationships[0]);
        this.executeCommandExpectingException("rmnode " + middleNode.getId(), "still has relationships");
        this.assertNodeExists(middleNode);
        Node endNode = this.getEndNode(relationships[1]);
        this.executeCommand("rmnode -f " + middleNode.getId(), "deleted");
        this.assertNodeDoesntExist(middleNode);
        this.assertRelationshipDoesntExist(relationships[0]);
        this.assertRelationshipDoesntExist(relationships[1]);
        this.assertNodeExists(endNode);
        this.executeCommand("cd -a " + endNode.getId(), new String[0]);
        this.executeCommand("rmnode " + endNode.getId(), new String[0]);
        this.executeCommand("pwd", Pattern.quote("(?)"));
    }

    private Node getEndNode(Relationship relationship) {
        this.beginTx();
        try {
            Node node = relationship.getEndNode();
            return node;
        }
        finally {
            this.finishTx(false);
        }
    }

    @Test
    public void pwdWorksOnDeletedNode() throws Exception {
        Relationship[] relationships = this.createRelationshipChain(1);
        this.executeCommand("cd " + this.getEndNode(relationships[0]).getId(), new String[0]);
        this.beginTx();
        relationships[0].getEndNode().delete();
        relationships[0].delete();
        this.finishTx();
        Relationship[] otherRelationships = this.createRelationshipChain(1);
        this.executeCommand("pwd", "Current is .+");
        this.executeCommand("cd -a " + this.getEndNode(otherRelationships[0]).getId(), new String[0]);
        this.executeCommand("ls", new String[0]);
    }

    @Test
    public void startEvenIfReferenceNodeHasBeenDeleted() throws Exception {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            String name = "Test";
            node.setProperty("name", (Object)name);
            tx.success();
        }
        GraphDatabaseShellServer server = new GraphDatabaseShellServer(this.db);
        SameJvmClient client = this.newShellClient((ShellServer)server);
        this.executeCommand((ShellClient)client, "pwd", Pattern.quote("(?)"));
        this.executeCommand((ShellClient)client, "ls " + node.getId(), "Test");
        this.executeCommand((ShellClient)client, "cd -a " + node.getId(), new String[0]);
        this.executeCommand((ShellClient)client, "ls", "Test");
    }

    @Test
    public void cypherWithSelfParameter() throws Exception {
        String nodeOneName = "Node ONE";
        String name = "name";
        String nodeTwoName = "Node TWO";
        String relationshipName = "The relationship";
        this.beginTx();
        Node node = this.db.createNode();
        node.setProperty(name, (Object)nodeOneName);
        Node otherNode = this.db.createNode();
        otherNode.setProperty(name, (Object)nodeTwoName);
        Relationship relationship = node.createRelationshipTo(otherNode, RELATIONSHIP_TYPE);
        relationship.setProperty(name, (Object)relationshipName);
        Node strayNode = this.db.createNode();
        this.finishTx();
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("MATCH (n) WHERE n = {self} RETURN n.name;", nodeOneName);
        this.executeCommand("cd -r " + relationship.getId(), new String[0]);
        this.executeCommand("MATCH ()-[r]->() WHERE r = {self} RETURN r.name;", relationshipName);
        this.executeCommand("cd " + otherNode.getId(), new String[0]);
        this.executeCommand("MATCH (n) WHERE n = {self} RETURN n.name;", nodeTwoName);
        this.executeCommand("cd -a " + strayNode.getId(), new String[0]);
        this.beginTx();
        strayNode.delete();
        this.finishTx();
        this.executeCommand("MATCH (n) WHERE id(n) = " + node.getId() + " RETURN n.name;", nodeOneName);
    }

    @Test
    public void cypherTiming() throws Exception {
        this.beginTx();
        Node node = this.db.createNode();
        Node otherNode = this.db.createNode();
        node.createRelationshipTo(otherNode, RELATIONSHIP_TYPE);
        this.finishTx();
        this.executeCommand("MATCH (n) WHERE id(n) = " + node.getId() + " optional match p=(n)-[r*]-(m) RETURN p;", "\\d+ ms", "1 row");
    }

    @Test
    public void filterProperties() throws Exception {
        this.beginTx();
        Node node = this.db.createNode();
        node.setProperty("name", (Object)"Mattias");
        node.setProperty("blame", (Object)"Someone else");
        this.finishTx();
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("ls", "Mattias");
        this.executeCommand("ls -pf name", "Mattias", "!Someone else");
        this.executeCommand("ls -f name", "Mattias", "!Someone else");
        this.executeCommand("ls -f blame", "!Mattias", "Someone else");
        this.executeCommand("ls -pf .*ame", "Mattias", "Someone else");
        this.executeCommand("ls -f .*ame", "Mattias", "Someone else");
    }

    @Test
    public void createNewNode() throws Exception {
        this.executeCommand("mknode --np \"{'name':'test'}\" --cd", new String[0]);
        this.executeCommand("ls", "name", "test", "!-");
        this.executeCommand("mkrel -t KNOWS 0", new String[0]);
        this.executeCommand("ls", "name", "test", "-", "KNOWS");
    }

    @Test
    public void createNodeWithArrayProperty() throws Exception {
        this.executeCommand("mknode --np \"{'values':[1,2,3,4]}\" --cd", new String[0]);
        Assert.assertThat((Object)this.getCurrentNode(), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"values").withValue((Object)new int[]{1, 2, 3, 4})));
    }

    @Test
    public void createNodeWithLabel() throws Exception {
        this.executeCommand("mknode --cd -l Person", new String[0]);
        Assert.assertThat((Object)this.getCurrentNode(), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person"})));
    }

    @Test
    public void createNodeWithColonPrefixedLabel() throws Exception {
        this.executeCommand("mknode --cd -l :Person", new String[0]);
        Assert.assertThat((Object)this.getCurrentNode(), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person"})));
    }

    @Test
    public void createNodeWithPropertiesAndLabels() throws Exception {
        this.executeCommand("mknode --cd --np \"{'name': 'Test'}\" -l \"['Person', ':Thing']\"", new String[0]);
        Assert.assertThat((Object)this.getCurrentNode(), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"Test")));
        Assert.assertThat((Object)this.getCurrentNode(), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person", "Thing"})));
    }

    @Test
    public void createRelationshipWithArrayProperty() throws Exception {
        String type = "ARRAY";
        this.executeCommand("mknode --cd", new String[0]);
        this.executeCommand("mkrel -ct " + type + " --rp \"{'values':[1,2,3,4]}\"", new String[0]);
        try (Transaction ignored = this.db.beginTx();){
            Assert.assertThat((Object)this.getCurrentNode().getSingleRelationship(RelationshipType.withName((String)type), Direction.OUTGOING), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasProperty((String)"values").withValue((Object)new int[]{1, 2, 3, 4})));
        }
    }

    @Test
    public void createRelationshipToNewNodeWithLabels() throws Exception {
        String type = "TEST";
        this.executeCommand("mknode --cd", new String[0]);
        this.executeCommand("mkrel -ctl " + type + " Person", new String[0]);
        try (Transaction ignored = this.db.beginTx();){
            Assert.assertThat((Object)this.getCurrentNode().getSingleRelationship(RelationshipType.withName((String)type), Direction.OUTGOING).getEndNode(), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person"})));
        }
    }

    @Test
    public void getDbinfo() throws Exception {
        this.executeCommand("dbinfo -g Kernel", "\\{", "\\}", "StoreId");
    }

    @Test
    public void canReassignShellVariables() throws Exception {
        this.executeCommand("export a=10", new String[0]);
        this.executeCommand("export b=a", new String[0]);
        this.executeCommand("env", "a=10", "b=10");
    }

    @Test
    public void canSetVariableToMap() throws Exception {
        this.executeCommand("export a={a:10}", new String[0]);
        this.executeCommand("export b={\"b\":\"foo\"}", new String[0]);
        this.executeCommand("env", "a=\\{a=10\\}", "b=\\{b=foo\\}");
    }

    @Test
    public void canSetVariableToScalars() throws Exception {
        this.executeCommand("export a=true", new String[0]);
        this.executeCommand("export b=100", new String[0]);
        this.executeCommand("export c=\"foo\"", new String[0]);
        this.executeCommand("env", "a=true", "b=100", "c=foo");
    }

    @Test
    public void canSetVariableToArray() throws Exception {
        this.executeCommand("export a=[1,true,\"foo\"]", new String[0]);
        this.executeCommand("env", "a=\\[1, true, foo\\]");
    }

    @Test
    public void canRemoveShellVariables() throws Exception {
        this.executeCommand("export a=10", new String[0]);
        this.executeCommand("export a=null", new String[0]);
        this.executeCommand("env", "!a=10", "!a=null");
    }

    @Test
    public void canUseAlias() throws Exception {
        this.executeCommand("alias x=pwd", new String[0]);
        this.executeCommand("x", "Current is .+");
    }

    @Test
    public void cypherNodeStillHasRelationshipsException() throws Exception {
        this.executeCommand("create (a),(b),(a)-[:x]->(b);", new String[0]);
        String stackTrace = "";
        try {
            this.executeCommand("match (n) delete n;", new String[0]);
            Assert.fail((String)("Should have failed with " + NodeStillHasRelationshipsException.class.getName() + " exception"));
        }
        catch (ShellException e) {
            stackTrace = e.getStackTraceAsString();
        }
        Assert.assertThat((Object)stackTrace, (Matcher)StringContains.containsString((String)"still has relationships"));
    }

    @Test
    public void startCypherQueryWithUnwind() throws Exception {
        this.executeCommand("unwind [1,2,3] as x return x;", "| x |", "| 1 |");
    }

    @Test
    public void useCypherMerge() throws Exception {
        this.executeCommand("merge (n:Person {name:'Andres'});", new String[0]);
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)Label.label((String)"Person"), (String)"name", (Object)"Andres", (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.hasSize((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void use_cypher_periodic_commit() throws Exception {
        File file = File.createTempFile("file", "csv", null);
        try (PrintWriter writer = new PrintWriter(file);){
            String url = file.toURI().toURL().toString().replace("\\", "\\\\");
            writer.println("1,2,3");
            writer.println("4,5,6");
            writer.close();
            this.executeCommand("USING PERIODIC COMMIT 100 LOAD CSV FROM '" + url + "' AS line CREATE ();", "Nodes created: 2");
        }
        catch (ShellException e) {
            Assert.fail((String)"Failed to execute PERIODIC COMMIT query");
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void canSetInitialSessionVariables() throws Exception {
        Map values = MapUtil.genericMap((Object[])new Object[]{"mykey", "myvalue", "my_other_key", "My other value"});
        SameJvmClient client = this.newShellClient(this.shellServer, values);
        String[] allStrings = new String[values.size() * 2];
        int i = 0;
        for (Map.Entry entry : values.entrySet()) {
            allStrings[i++] = (String)entry.getKey();
            allStrings[i++] = ((Serializable)entry.getValue()).toString();
        }
        this.executeCommand((ShellClient)client, "env", allStrings);
    }

    @Test
    public void canDisableWelcomeMessage() throws Exception {
        Map values = MapUtil.genericMap((Object[])new Object[]{"quiet", "true"});
        CollectingOutput out = new CollectingOutput();
        SameJvmClient client = new SameJvmClient(values, this.shellServer, (Output)out);
        client.shutdown();
        String outString = out.asString();
        Assert.assertEquals((String)("Shows welcome message: " + outString), (Object)false, (Object)outString.contains("Welcome to the Neo4j Shell! Enter 'help' for a list of commands"));
    }

    @Test
    public void doesShowWelcomeMessage() throws Exception {
        Map values = MapUtil.genericMap((Object[])new Object[0]);
        CollectingOutput out = new CollectingOutput();
        SameJvmClient client = new SameJvmClient(values, this.shellServer, (Output)out);
        client.shutdown();
        String outString = out.asString();
        Assert.assertEquals((String)("Shows welcome message: " + outString), (Object)true, (Object)outString.contains("Welcome to the Neo4j Shell! Enter 'help' for a list of commands"));
    }

    @Test
    public void canExecuteCypherWithShellVariables() throws Exception {
        Map variables = MapUtil.genericMap((Object[])new Object[]{"id", 0});
        SameJvmClient client = this.newShellClient(this.shellServer, variables);
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode();
            tx.success();
        }
        this.executeCommand((ShellClient)client, "match (n) where id(n) = {id} return n;", "1 row");
    }

    @Test
    public void canDumpSubgraphWithCypher() throws Exception {
        RelationshipType type = RelationshipType.withName((String)"KNOWS");
        this.beginTx();
        this.createRelationshipChain(this.db.createNode(), type, 1);
        this.finishTx();
        this.executeCommand("dump match (n)-[r]->(m) where id(n) = 0 return n,r,m;", "begin", "create \\(_0\\)", "create \\(_1\\)", "\\(_0\\)-\\[:`KNOWS`\\]->\\(_1\\)", "commit");
    }

    @Test
    public void canDumpGraph() throws Exception {
        RelationshipType type = RelationshipType.withName((String)"KNOWS");
        this.beginTx();
        Relationship rel = this.createRelationshipChain(this.db.createNode(), type, 1)[0];
        rel.getStartNode().setProperty("f o o", (Object)"bar");
        rel.setProperty("since", (Object)2010);
        rel.getEndNode().setProperty("flags", (Object)new Boolean[]{true, false, true});
        this.finishTx();
        this.executeCommand("dump ", "begin", "create \\(_0 \\{\\`f o o\\`:\"bar\"\\}\\)", "create \\(_1 \\{`flags`:\\[true, false, true\\]\\}\\)", "\\(_0\\)-\\[:`KNOWS` \\{`since`:2010\\}\\]->\\(_1\\)", "commit");
    }

    @Test
    public void commentsAreIgnored() throws Exception {
        this.executeCommand("// a comment\n", new String[0]);
    }

    @Test
    public void canAddLabelToNode() throws Exception {
        Relationship[] chain = this.createRelationshipChain(1);
        Node node = this.getEndNode(chain[0]);
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("set -l Person", new String[0]);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person"})));
    }

    @Test
    public void canAddMultipleLabelsToNode() throws Exception {
        Relationship[] chain = this.createRelationshipChain(1);
        Node node = this.getEndNode(chain[0]);
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("set -l ['Person','Thing']", new String[0]);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person", "Thing"})));
    }

    @Test
    public void canRemoveLabelFromNode() throws Exception {
        this.beginTx();
        Relationship[] chain = this.createRelationshipChain(1);
        Node node = chain[0].getEndNode();
        node.addLabel(Label.label((String)"Person"));
        node.addLabel(Label.label((String)"Pilot"));
        this.finishTx();
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("rm -l Person", new String[0]);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Pilot"})));
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)IsNot.not((Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person"}))));
    }

    @Test
    public void canRemoveMultipleLabelsFromNode() throws Exception {
        this.beginTx();
        Relationship[] chain = this.createRelationshipChain(1);
        Node node = chain[0].getEndNode();
        node.addLabel(Label.label((String)"Person"));
        node.addLabel(Label.label((String)"Thing"));
        node.addLabel(Label.label((String)"Object"));
        this.finishTx();
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("rm -l ['Person','Object']", new String[0]);
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Thing"})));
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)IsNot.not((Matcher)Neo4jMatchers.hasLabels((String[])new String[]{"Person", "Object"}))));
    }

    @Test
    public void canListLabels() throws Exception {
        this.beginTx();
        Relationship[] chain = this.createRelationshipChain(1);
        Node node = chain[0].getEndNode();
        node.addLabel(Label.label((String)"Person"));
        node.addLabel(Label.label((String)"Father"));
        this.finishTx();
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("ls", ":Person", ":Father");
    }

    @Test
    public void canListFilteredLabels() throws Exception {
        this.beginTx();
        Relationship[] chain = this.createRelationshipChain(1);
        Node node = chain[0].getEndNode();
        node.addLabel(Label.label((String)"Person"));
        node.addLabel(Label.label((String)"Father"));
        this.finishTx();
        this.executeCommand("cd -a " + node.getId(), new String[0]);
        this.executeCommand("ls -f Per.*", ":Person", "!:Father");
    }

    @Test
    public void canListIndexes() throws Exception {
        Label label = Label.label((String)"Person");
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on("name").create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        this.executeCommand("schema ls", ":Person", Schema.IndexState.ONLINE.name());
    }

    @Test
    public void canListIndexesForGivenLabel() throws Exception {
        Label label1 = Label.label((String)"Person");
        Label label2 = Label.label((String)"Building");
        this.beginTx();
        IndexDefinition index1 = this.db.schema().indexFor(label1).on("name").create();
        IndexDefinition index2 = this.db.schema().indexFor(label2).on("name").create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index1);
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index2);
        this.executeCommand("schema ls -l " + label2.name(), ":" + label2.name(), Schema.IndexState.ONLINE.name(), "!:" + label1.name());
    }

    @Test
    public void canListIndexesForGivenPropertyAndLabel() throws Exception {
        Label label1 = Label.label((String)"Person");
        Label label2 = Label.label((String)"Thing");
        String property1 = "name";
        String property2 = "age";
        this.beginTx();
        IndexDefinition index1 = this.db.schema().indexFor(label1).on(property1).create();
        IndexDefinition index2 = this.db.schema().indexFor(label1).on(property2).create();
        IndexDefinition index3 = this.db.schema().indexFor(label2).on(property1).create();
        IndexDefinition index4 = this.db.schema().indexFor(label2).on(property2).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index1);
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index2);
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index3);
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index4);
        this.executeCommand("schema ls -l :" + label2.name() + " -p " + property1, label2.name(), property1, "!" + label1.name(), "!" + property2);
    }

    @Test
    public void canAwaitIndexesToComeOnline() throws Exception {
        Label label = Label.label((String)"Person");
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on("name").create();
        this.finishTx();
        this.executeCommand("schema await -l " + label.name(), new String[0]);
        this.beginTx();
        Assert.assertEquals((Object)Schema.IndexState.ONLINE, (Object)this.db.schema().getIndexState(index));
        this.finishTx();
    }

    @Test
    public void canListIndexesWhenNoOptionGiven() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        this.executeCommand("schema", label.name(), property);
    }

    @Test
    public void canListUniquePropertyConstraints() throws Exception {
        Label label = Label.label((String)"Person");
        this.beginTx();
        this.db.schema().constraintFor(label).assertPropertyIsUnique("name").create();
        this.finishTx();
        this.executeCommand("schema ls", "ON \\(person:Person\\) ASSERT person.name IS UNIQUE");
    }

    @Test
    public void canListUniquePropertyConstraintsByLabel() throws Exception {
        Label label1 = Label.label((String)"Person");
        this.beginTx();
        this.db.schema().constraintFor(label1).assertPropertyIsUnique("name").create();
        this.finishTx();
        this.executeCommand("schema ls -l :Person", "ON \\(person:Person\\) ASSERT person.name IS UNIQUE");
    }

    @Test
    public void canListUniquePropertyConstraintsByLabelAndProperty() throws Exception {
        Label label1 = Label.label((String)"Person");
        this.beginTx();
        this.db.schema().constraintFor(label1).assertPropertyIsUnique("name").create();
        this.finishTx();
        this.executeCommand("schema ls -l :Person -p name", "ON \\(person:Person\\) ASSERT person.name IS UNIQUE");
    }

    @Test
    public void failSampleWhenNoOptionGiven() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        try {
            this.executeCommand("schema sample", new String[0]);
            Assert.fail((String)"This should fail");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"Invalid usage of sample"));
        }
    }

    @Test
    public void canSampleAllIndexes() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        this.executeCommand("schema sample -a", new String[0]);
    }

    @Test
    public void canForceSampleIndexes() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        this.executeCommand("schema sample -a -f", new String[0]);
    }

    @Test
    public void canSampleSpecificIndex() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        this.executeCommand("schema sample -l Person -p name", new String[0]);
    }

    @Test
    public void failSamplingWhenProvidingBadLabel() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        try {
            this.executeCommand("schema sample -l People -p name", new String[0]);
            Assert.fail((String)"This should fail");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"No label associated with 'People' was found"));
        }
    }

    @Test
    public void failSamplingWhenProvidingBadProperty() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        try {
            this.executeCommand("schema sample -l Person -p namn", new String[0]);
            Assert.fail((String)"This should fail");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"No property associated with 'namn' was found"));
        }
    }

    @Test
    public void failSamplingWhenProvidingOnlyLabel() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        try {
            this.executeCommand("schema sample -l Person", new String[0]);
            Assert.fail((String)"This should fail");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"Provide both the property and the label, or run with -a to sample all indexes"));
        }
    }

    @Test
    public void failSamplingWhenProvidingOnlyProperty() throws Exception {
        Label label = Label.label((String)"Person");
        String property = "name";
        this.beginTx();
        IndexDefinition index = this.db.schema().indexFor(label).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index);
        try {
            this.executeCommand("schema sample -p name", new String[0]);
            Assert.fail((String)"This should fail");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"Provide both the property and the label, or run with -a to sample all indexes"));
        }
    }

    @Test
    public void failSamplingWhenProvidingMultipleLabels() throws Exception {
        Label label = Label.label((String)"Person");
        Label otherLabel = Label.label((String)"Dog");
        String property = "name";
        this.beginTx();
        IndexDefinition index1 = this.db.schema().indexFor(label).on(property).create();
        IndexDefinition index2 = this.db.schema().indexFor(otherLabel).on(property).create();
        this.finishTx();
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index1);
        Neo4jMatchers.waitForIndex((GraphDatabaseService)this.db, (IndexDefinition)index2);
        try {
            this.executeCommand("schema sample -p name -l [Person,Dog]", new String[0]);
            Assert.fail((String)"This should fail");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"Only one label must be provided"));
        }
    }

    @Test
    public void committingFailedTransactionShouldProperlyFinishTheTransaction() throws Exception {
        this.executeCommand("begin", new String[0]);
        this.executeCommand("create constraint on (node:Label1) assert node.key1 is unique;", new String[0]);
        try {
            this.executeCommand("mknode --cd", new String[0]);
            Assert.fail((String)"Should have failed");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)ConstraintViolationException.class.getSimpleName()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"Cannot perform data updates"));
        }
        try {
            this.executeCommand("commit", new String[0]);
            Assert.fail((String)"Commit should fail");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"rolled back"));
        }
        try {
            this.executeCommand("rollback", new String[0]);
            Assert.fail((String)"Rolling back at this point should fail since there's no transaction open");
        }
        catch (ShellException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)"Not in a transaction"));
        }
    }

    @Test
    public void allowsArgumentsStartingWithSingleHyphensForCommandsThatDontTakeOptions() throws Exception {
        this.executeCommand("CREATE (n { test : ' -0' });", new String[0]);
    }

    @Test
    public void allowsArgumentsStartingWithDoubldHyphensForCommandsThatDontTakeOptions() throws Exception {
        this.executeCommand("MATCH () -- () RETURN 0;", new String[0]);
    }

    @Test
    public void allowsCypherToContainExclamationMarks() throws Exception {
        this.executeCommand("RETURN \"a\"+\"!b\";", "a!b");
    }

    @Test
    public void shouldAllowQueriesToStartWithOptionalMatch() throws Exception {
        this.executeCommand("OPTIONAL MATCH (n) RETURN n;", new String[0]);
    }

    @Test
    public void shouldAllowExplainAsStartForACypherQuery() throws Exception {
        this.executeCommand("EXPLAIN OPTIONAL MATCH (n) RETURN n;", "No data returned");
    }

    @Test
    public void shouldAllowProfileAsStartForACypherQuery() throws Exception {
        this.executeCommand("PROFILE MATCH (n) RETURN n;", "DB Hits");
    }

    @Test
    public void shouldAllowPlannerAsStartForACypherQuery() throws Exception {
        this.executeCommand("CYPHER planner=cost MATCH (n) RETURN n;", new String[0]);
    }

    @Test
    public void canListAllConfiguration() throws Exception {
        this.executeCommand("dbinfo -g Configuration", "\"dbms.record_format\": \"\"");
    }

    @Test
    public void canTerminateAnActiveCommand() throws Exception {
        TransactionStats txStats = (TransactionStats)this.db.getDependencyResolver().resolveDependency(TransactionStats.class);
        Assert.assertEquals((long)0L, (long)txStats.getNumberOfActiveTransactions());
        Serializable clientId = this.shellClient.getId();
        Future result = ForkJoinPool.commonPool().submit(() -> {
            try {
                while (txStats.getNumberOfActiveTransactions() == 0L) {
                    Thread.sleep(10L);
                }
                Assert.assertEquals((long)1L, (long)txStats.getNumberOfActiveTransactions());
                this.shellServer.terminate(clientId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.executeCommandExpectingException("FOREACH(i IN range(0, 2147483647) | CREATE ());", "has been terminated");
        Assert.assertNull(result.get());
    }

    @Test
    public void canUseForeach() throws Exception {
        this.executeCommand("FOREACH(x in range(0,10) | CREATE ());", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void use_cypher_periodic_commit2() throws Exception {
        File file = File.createTempFile("file", "csv", null);
        try (PrintWriter writer = new PrintWriter(file);){
            String url = file.toURI().toURL().toString().replace("\\", "\\\\");
            writer.println("apa,2,3");
            writer.println("4,5,6");
            writer.close();
            this.executeCommand("USING PERIODIC COMMIT 100 LOAD CSV FROM '" + url + "' AS line CREATE () RETURN line;", "apa");
        }
        catch (ShellException e) {
            Assert.fail((String)"Failed to execute PERIODIC COMMIT query");
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void canUseCall() throws Exception {
        this.executeCommand("CALL db.labels", new String[0]);
    }

    @Test
    public void shouldSupportUsingPeriodicCommitInSession() throws Exception {
        long fileSize = 120L;
        long batch = 40L;
        String csvFileUrl = this.createCsvFile(fileSize);
        long expectedCommitCount = fileSize / batch;
        this.verifyNumberOfCommits("USING PERIODIC COMMIT " + batch + " LOAD CSV FROM '" + csvFileUrl + "' AS l CREATE ();", expectedCommitCount);
    }

    @Test
    public void shouldSupportUsingPeriodicCommitInMultipleLine() throws Exception {
        long fileSize = 120L;
        long batch = 40L;
        String csvFileUrl = this.createCsvFile(fileSize);
        long expectedCommitCount = fileSize / batch;
        this.verifyNumberOfCommits("USING\nPERIODIC\nCOMMIT\n" + batch + "\nLOAD\nCSV\nFROM '" + csvFileUrl + "' AS l\nCREATE ();", expectedCommitCount);
    }

    private void verifyNumberOfCommits(String query, long expectedCommitCount) throws Exception {
        CtrlCHandler ctrlCHandler = (CtrlCHandler)Mockito.mock(CtrlCHandler.class);
        StartClient startClient = this.getStartClient();
        long txIdBeforeQuery = this.lastClosedTxId();
        startClient.start(new String[]{"-path", this.db.getStoreDir(), "-c", query}, ctrlCHandler);
        long txId = this.lastClosedTxId();
        Assert.assertEquals((long)(expectedCommitCount + txIdBeforeQuery + 1L), (long)txId);
    }

    private StartClient getStartClient() {
        return new StartClient(System.out, System.err){

            protected GraphDatabaseShellServer getGraphDatabaseShellServer(File path, boolean readOnly, String configFile) throws RemoteException {
                return new GraphDatabaseShellServer(AppsIT.this.db);
            }
        };
    }

    private long lastClosedTxId() {
        return ((TransactionIdStore)this.db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }

    private String createCsvFile(long size) throws IOException, InterruptedException {
        File tmpFile = File.createTempFile("data", ".csv", null);
        tmpFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(tmpFile);){
            out.println("foo");
            int i = 0;
            while ((long)i < size) {
                out.println(i);
                ++i;
            }
        }
        return tmpFile.toURI().toURL().toExternalForm();
    }
}

