/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.BashVariableInterpreter;

public class BashVariableInterpreterTest {
    private final BashVariableInterpreter interpreter = new BashVariableInterpreter();
    private final Session session = new Session((Serializable)Integer.valueOf(0));
    private ShellServer server;

    @Test
    public void shouldInterpretDate() throws Exception {
        String interpreted = this.interpreter.interpret("Date:\\d", this.server, this.session);
        String datePart = interpreted.substring("Date:".length());
        Assert.assertNotNull((Object)new SimpleDateFormat("EEE MMM dd").parse(datePart));
    }

    @Test
    public void shouldInterpretTime() throws Exception {
        String interpreted = this.interpreter.interpret("Time:\\t", this.server, this.session);
        String datePart = interpreted.substring("Time:".length());
        Assert.assertNotNull((Object)new SimpleDateFormat("HH:mm:ss").parse(datePart));
    }

    @Test
    public void customInterpreter() throws Exception {
        this.interpreter.addReplacer("test", new BashVariableInterpreter.Replacer(){

            public String getReplacement(ShellServer server, Session session) throws ShellException {
                return "Hello";
            }
        });
        String interpreted = this.interpreter.interpret("\\test world", this.server, this.session);
        Assert.assertEquals((Object)"Hello world", (Object)interpreted);
    }

    @Before
    public void before() throws Exception {
        this.server = (ShellServer)Mockito.mock(ShellServer.class);
        Mockito.when((Object)this.server.getName()).thenReturn((Object)"Server");
    }
}

