/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.shell.DontShutdownClient;
import org.neo4j.shell.DontShutdownLocalServer;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.rule.TestDirectory;

public class TestRmiPublication {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    public static File createDefaultConfigFile(File path) throws IOException {
        File configFile = new File(path, "neo4j.conf");
        Properties config = new Properties();
        config.setProperty(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        try (FileWriter writer = new FileWriter(configFile);){
            config.store(writer, "");
        }
        return configFile;
    }

    @Test
    public void jvmShouldDieEvenIfWeLeaveSameJvmClientIsLeftHanging() throws Exception {
        Assert.assertEquals((long)0L, (long)this.spawnJvm(DontShutdownClient.class, "client"));
    }

    @Test
    public void jvmShouldDieEvenIfLocalServerIsLeftHanging() throws Exception {
        Assert.assertEquals((long)0L, (long)this.spawnJvm(DontShutdownLocalServer.class, "server"));
    }

    private int spawnJvm(Class<?> mainClass, String name) throws Exception {
        String dir = this.testDirectory.directory(name).getAbsolutePath();
        return this.waitForExit(Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), "-Djava.awt.headless=true", mainClass.getName(), dir}), 20);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int waitForExit(Process process, int maxSeconds) throws InterruptedException {
        try {
            long endTime = System.currentTimeMillis() + (long)(maxSeconds * 1000);
            ProcessStreamHandler streamHandler = new ProcessStreamHandler(process, false);
            streamHandler.launch();
            try {
                while (System.currentTimeMillis() < endTime) {
                    try {
                        int n = process.exitValue();
                        return n;
                    }
                    catch (IllegalThreadStateException e) {
                        Thread.sleep(100L);
                    }
                }
                this.tempHackToGetThreadDump(process);
                throw new RuntimeException("Process didn't exit on its own.");
            }
            finally {
                streamHandler.cancel();
            }
        }
        finally {
            process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tempHackToGetThreadDump(Process process) {
        try {
            Field pidField = process.getClass().getDeclaredField("pid");
            pidField.setAccessible(true);
            int pid = (Integer)pidField.get(process);
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", "kill -3 " + pid);
            processBuilder.redirectErrorStream(true);
            Process dumpProc = processBuilder.start();
            ProcessStreamHandler streamHandler = new ProcessStreamHandler(dumpProc, false);
            streamHandler.launch();
            try {
                process.waitFor();
            }
            finally {
                streamHandler.cancel();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

