/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.rmi.RemoteException;
import org.junit.Test;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.shell.AbstractShellTest;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.ReadOnlyGraphDatabaseProxy;

public class TestReadOnlyServer
extends AbstractShellTest {
    @Override
    protected ShellServer newServer(GraphDatabaseAPI db) throws ShellException, RemoteException {
        return new GraphDatabaseShellServer((GraphDatabaseAPI)new ReadOnlyGraphDatabaseProxy(db));
    }

    @Test
    public void executeReadCommands() throws Exception {
        Relationship[] rels = this.createRelationshipChain(3);
        this.executeCommand("cd " + this.getStartNodeId(rels[0]), new String[0]);
        this.executeCommand("ls", new String[0]);
        this.executeCommand("cd " + this.getEndNodeId(rels[0]), new String[0]);
        this.executeCommand("ls", "<", ">");
        this.executeCommand("trav", "me");
    }

    @Test
    public void readOnlyTransactionsShouldNotFail() throws Exception {
        Relationship[] rels = this.createRelationshipChain(3);
        this.executeCommand("begin", new String[0]);
        this.executeCommand("cd " + this.getStartNodeId(rels[0]), new String[0]);
        this.executeCommand("ls", new String[0]);
        this.executeCommand("commit", new String[0]);
    }

    private long getEndNodeId(Relationship rel) {
        try (Transaction ignore = this.db.beginTx();){
            long l = rel.getEndNode().getId();
            return l;
        }
    }

    private long getStartNodeId(Relationship rel) {
        try (Transaction ignore = this.db.beginTx();){
            long l = rel.getStartNode().getId();
            return l;
        }
    }

    @Test
    public void executeWriteCommands() throws Exception {
        this.executeCommandExpectingException("mknode", "read only");
    }
}

