/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.ShellSettings;
import org.neo4j.shell.StartClient;
import org.neo4j.shell.Welcome;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;

public class StartClientTest {
    @Rule
    public SuppressOutput mute = SuppressOutput.suppressAll();
    @Rule
    public ImpermanentDatabaseRule db = new ImpermanentDatabaseRule(){

        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(ShellSettings.remote_shell_enabled, "true");
        }
    };

    @Before
    public void startDatabase() {
        this.db.getGraphDatabaseAPI();
    }

    @Test
    public void givenShellClientWhenOpenFileThenExecuteFileCommands() {
        StartClient.main((String[])new String[]{"-file", this.getClass().getResource("/testshell.txt").getFile()});
        try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
            Assert.assertThat((Object)((String)this.db.getGraphDatabaseAPI().getNodeById(0L).getProperty("foo")), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            tx.success();
        }
    }

    @Test
    public void givenShellClientWhenReadFromStdinThenExecutePipedCommands() throws IOException {
        InputStream realStdin = System.in;
        try {
            System.setIn(new ByteArrayInputStream("CREATE (n {foo:'bar'});".getBytes()));
            StartClient.main((String[])new String[]{"-file", "-"});
        }
        finally {
            System.setIn(realStdin);
        }
        try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
            Assert.assertThat((Object)((String)this.db.getGraphDatabaseAPI().getNodeById(0L).getProperty("foo")), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            tx.success();
        }
    }

    @Test
    public void mustWarnWhenRunningScriptWithUnterminatedMultilineCommands() {
        String script = this.getClass().getResource("/unterminated-cypher-query.txt").getFile();
        String output = this.runAndCaptureOutput(new String[]{"-file", script});
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Warning: Exiting with unterminated multi-line input."));
    }

    @Test
    public void mustNotAboutExitingWithUnterminatedCommandWhenItIsNothingButComments() {
        String script = this.getClass().getResource("/unterminated-comment.txt").getFile();
        String output = this.runAndCaptureOutput(new String[]{"-file", script});
        Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"Warning: Exiting with unterminated multi-line input.")));
    }

    @Test
    public void testShellCloseAfterCommandExecution() throws Exception {
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        PrintStream err = (PrintStream)Mockito.mock(PrintStream.class);
        CtrlCHandler ctrlCHandler = (CtrlCHandler)Mockito.mock(CtrlCHandler.class);
        final GraphDatabaseShellServer databaseShellServer = (GraphDatabaseShellServer)Mockito.mock(GraphDatabaseShellServer.class);
        Mockito.when((Object)databaseShellServer.welcome(Mockito.anyMap())).thenReturn((Object)new Welcome("", (Serializable)Integer.valueOf(1), ""));
        Mockito.when((Object)databaseShellServer.interpretLine((Serializable)Mockito.any(Serializable.class), (String)Mockito.any(String.class), (Output)Mockito.any(Output.class))).thenReturn((Object)new Response("", Continuation.INPUT_COMPLETE));
        StartClient startClient = new StartClient(out, err){

            protected GraphDatabaseShellServer getGraphDatabaseShellServer(File path, boolean readOnly, String configFile) throws RemoteException {
                return databaseShellServer;
            }
        };
        startClient.start(new String[]{"-path", this.db.getGraphDatabaseAPI().getStoreDir(), "-c", "CREATE (n {foo:'bar'});"}, ctrlCHandler);
        ((GraphDatabaseShellServer)Mockito.verify((Object)databaseShellServer)).shutdown();
    }

    @Test
    public void shouldReportEditionThroughDbInfoApp() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        CtrlCHandler ctrlCHandler = (CtrlCHandler)Mockito.mock(CtrlCHandler.class);
        StartClient client = new StartClient(new PrintStream(out), new PrintStream(err));
        client.start(new String[]{"-path", this.db.getGraphDatabaseAPI().getStoreDir(), "-c", "dbinfo -g Configuration unsupported.dbms.edition"}, ctrlCHandler);
        Assert.assertEquals((long)0L, (long)err.size());
        Assert.assertThat((Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"\"unsupported.dbms.edition\": \"community\""));
    }

    @Test
    public void shouldPrintVersionAndExit() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        CtrlCHandler ctrlCHandler = (CtrlCHandler)Mockito.mock(CtrlCHandler.class);
        StartClient client = new StartClient(new PrintStream(out), new PrintStream(err));
        client.start(new String[]{"-version"}, ctrlCHandler);
        Assert.assertEquals((long)0L, (long)err.size());
        String version = out.toString();
        Assert.assertThat((Object)version, (Matcher)CoreMatchers.startsWith((String)"Neo4j Community, version "));
    }

    @Test
    public void shouldNotStartBolt() throws IOException {
        final AssertableLogProvider log = new AssertableLogProvider();
        new StartClient(System.out, System.err){

            protected GraphDatabaseShellServer getGraphDatabaseShellServer(File path, boolean readOnly, String configFile) throws RemoteException {
                return new GraphDatabaseShellServer(new GraphDatabaseFactory().setUserLogProvider((LogProvider)log), path, readOnly, configFile);
            }
        }.start(new String[]{"-c", "RETURN 1;", "-path", this.db.getGraphDatabaseAPI().getStoreDir(), "-config", this.getClass().getResource("/config-with-bolt-connector.conf").getFile()}, (CtrlCHandler)Mockito.mock(CtrlCHandler.class));
        log.assertNone(AssertableLogProvider.inLog((Matcher)CoreMatchers.startsWith((String)WorkerFactory.class.getPackage().getName())).any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runAndCaptureOutput(String[] arguments) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buf);
        PrintStream oldOut = System.out;
        System.setOut(out);
        try {
            StartClient.main((String[])arguments);
            out.close();
            String string = buf.toString();
            return string;
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

