/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.SilentLocalOutput;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.impl.SimpleAppServer;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.ImpermanentGraphDatabase;

public class ServerClientInteractionTest {
    private GraphDatabaseAPI db;
    private SimpleAppServer server;
    private ShellClient client;
    private SilentLocalOutput out;

    @Test
    public void shouldConsiderAndInterpretCustomClientPrompt() throws Exception {
        this.client.setSessionVariable("PS1", (Serializable)((Object)"MyPrompt \\d \\t$ "));
        Response response = this.server.interpretLine(this.client.getId(), "", (Output)this.out);
        String regexPattern = "MyPrompt .{1,3} .{1,3} \\d{1,2} \\d{2}:\\d{2}:\\d{2}\\$";
        Assert.assertTrue((String)("Prompt from server '" + response.getPrompt() + "' didn't match pattern '" + regexPattern + "'"), (boolean)Pattern.compile(regexPattern).matcher(response.getPrompt()).find());
    }

    @Before
    public void before() throws Exception {
        this.db = new ImpermanentGraphDatabase();
        this.server = new GraphDatabaseShellServer(this.db);
        this.out = new SilentLocalOutput();
        this.client = new SameJvmClient(MapUtil.genericMap((Object[])new Object[0]), (ShellServer)this.server, (Output)this.out, (CtrlCHandler)InterruptSignalHandler.getHandler());
    }

    @After
    public void after() throws Exception {
        this.server.shutdown();
        this.db.shutdown();
    }
}

