/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.CollectingOutput;
import org.neo4j.shell.impl.RemoteClient;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public abstract class AbstractShellTest {
    protected GraphDatabaseAPI db;
    protected ShellServer shellServer;
    protected ShellClient shellClient;
    private Integer remotelyAvailableOnPort;
    protected static final RelationshipType RELATIONSHIP_TYPE = RelationshipType.withName((String)"TYPE");
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private Transaction tx;

    @Before
    public void doBefore() throws Exception {
        this.db = this.newDb();
        this.shellServer = this.newServer(this.db);
        this.shellClient = this.newShellClient(this.shellServer);
    }

    protected SameJvmClient newShellClient(ShellServer server) throws ShellException, RemoteException {
        return this.newShellClient(server, Collections.singletonMap("quiet", true));
    }

    protected SameJvmClient newShellClient(ShellServer server, Map<String, Serializable> session) throws ShellException, RemoteException {
        return new SameJvmClient(session, server, (Output)new CollectingOutput(), (CtrlCHandler)InterruptSignalHandler.getHandler());
    }

    protected GraphDatabaseAPI newDb() {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabase();
    }

    protected ShellServer newServer(GraphDatabaseAPI db) throws ShellException, RemoteException {
        return new GraphDatabaseShellServer(db);
    }

    @After
    public void doAfter() throws Exception {
        if (this.tx != null) {
            this.finishTx(false);
        }
        this.shellClient.shutdown();
        this.shellServer.shutdown();
        this.db.shutdown();
    }

    protected void beginTx() {
        assert (this.tx == null);
        this.tx = this.db.beginTx();
    }

    protected void finishTx() {
        this.finishTx(true);
    }

    protected ShellClient newRemoteClient() throws Exception {
        return this.newRemoteClient(ShellLobby.NO_INITIAL_SESSION);
    }

    protected ShellClient newRemoteClient(Map<String, Serializable> initialSession) throws Exception {
        return new RemoteClient(initialSession, ShellLobby.remoteLocation((int)this.remotelyAvailableOnPort), (Output)new CollectingOutput(), (CtrlCHandler)InterruptSignalHandler.getHandler());
    }

    protected void makeServerRemotelyAvailable() throws RemoteException {
        if (this.remotelyAvailableOnPort == null) {
            this.remotelyAvailableOnPort = this.findFreePort();
            this.shellServer.makeRemotelyAvailable(this.remotelyAvailableOnPort.intValue(), "shell");
        }
    }

    private int findFreePort() {
        return 1337;
    }

    protected void restartServer() throws Exception {
        this.shellServer.shutdown();
        this.db.shutdown();
        this.db = this.newDb();
        this.remotelyAvailableOnPort = null;
        this.shellServer = this.newServer(this.db);
        this.shellClient = this.newShellClient(this.shellServer);
    }

    protected void finishTx(boolean success) {
        assert (this.tx != null);
        if (success) {
            this.tx.success();
        }
        this.tx.close();
        this.tx = null;
    }

    protected static String pwdOutputFor(Object ... entities) {
        StringBuilder builder = new StringBuilder();
        for (Object entity : entities) {
            builder.append(builder.length() == 0 ? "" : "-->");
            if (entity instanceof Node) {
                builder.append("(").append(((Node)entity).getId()).append(")");
                continue;
            }
            builder.append("<").append(((Relationship)entity).getId()).append(">");
        }
        return Pattern.quote(builder.toString());
    }

    public void executeCommand(String command, String ... theseLinesMustExistRegEx) throws Exception {
        this.executeCommand(this.shellClient, command, theseLinesMustExistRegEx);
    }

    public void executeCommand(ShellClient client, String command, String ... theseLinesMustExistRegEx) throws Exception {
        CollectingOutput output = new CollectingOutput();
        client.evaluate(command, (Output)output);
        for (String lineThatMustExist : theseLinesMustExistRegEx) {
            boolean negative = lineThatMustExist.startsWith("!");
            lineThatMustExist = negative ? lineThatMustExist.substring(1) : lineThatMustExist;
            Pattern pattern = Pattern.compile(lineThatMustExist);
            boolean found = false;
            for (String line : output) {
                if (!pattern.matcher(line).find()) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Was expecting a line matching '" + lineThatMustExist + "', but didn't find any from out of " + Iterables.asCollection((Iterable)output)), (found != negative ? 1 : 0) != 0);
        }
    }

    public void executeCommandExpectingException(String command, String errorMessageShouldContain) throws Exception {
        block2: {
            CollectingOutput output = new CollectingOutput();
            try {
                this.shellClient.evaluate(command, (Output)output);
                Assert.fail((String)"Was expecting an exception");
            }
            catch (ShellException e) {
                String errorMessage = e.getMessage();
                if (errorMessage.toLowerCase().contains(errorMessageShouldContain.toLowerCase())) break block2;
                Assert.fail((String)("Error message '" + errorMessage + "' should have contained '" + errorMessageShouldContain + "'"));
            }
        }
    }

    protected void assertRelationshipDoesntExist(Relationship relationship) {
        this.assertRelationshipDoesntExist(relationship.getId());
    }

    protected void assertRelationshipDoesntExist(long id) {
        try (Transaction ignore = this.db.beginTx();){
            this.db.getRelationshipById(id);
            Assert.fail((String)("Relationship " + id + " shouldn't exist"));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    protected void assertNodeExists(Node node) {
        this.assertNodeExists(node.getId());
    }

    protected void assertNodeExists(long id) {
        try (Transaction ignore = this.db.beginTx();){
            this.db.getNodeById(id);
        }
        catch (NotFoundException e) {
            Assert.fail((String)("Node " + id + " should exist"));
        }
    }

    protected void assertNodeDoesntExist(Node node) {
        this.assertNodeDoesntExist(node.getId());
    }

    protected void assertNodeDoesntExist(long id) {
        try (Transaction ignore = this.db.beginTx();){
            this.db.getNodeById(id);
            Assert.fail((String)("Relationship " + id + " shouldn't exist"));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    protected Relationship[] createRelationshipChain(int length) {
        return this.createRelationshipChain(RELATIONSHIP_TYPE, length);
    }

    protected Relationship[] createRelationshipChain(RelationshipType type, int length) {
        try (Transaction transaction = this.db.beginTx();){
            Relationship[] relationshipChain = this.createRelationshipChain(this.db.createNode(), type, length);
            transaction.success();
            Relationship[] relationshipArray = relationshipChain;
            return relationshipArray;
        }
    }

    protected Relationship[] createRelationshipChain(Node startingFromNode, RelationshipType type, int length) {
        try (Transaction tx = this.db.beginTx();){
            Relationship[] rels = new Relationship[length];
            Node firstNode = startingFromNode;
            for (int i = 0; i < rels.length; ++i) {
                Node secondNode = this.db.createNode();
                rels[i] = firstNode.createRelationshipTo(secondNode, type);
                firstNode = secondNode;
            }
            tx.success();
            Relationship[] relationshipArray = rels;
            return relationshipArray;
        }
    }

    protected void deleteRelationship(Relationship relationship) {
        try (Transaction tx = this.db.beginTx();){
            relationship.delete();
            tx.success();
        }
    }

    protected void setProperty(Node node, String key, Object value) {
        try (Transaction tx = this.db.beginTx();){
            node.setProperty(key, value);
            tx.success();
        }
    }

    protected Node getCurrentNode() throws RemoteException, ShellException {
        Serializable current = this.shellServer.interpretVariable(this.shellClient.getId(), "CURRENT_DIR");
        int nodeId = Integer.parseInt(current.toString().substring(1));
        try (Transaction tx = this.db.beginTx();){
            Node nodeById = this.db.getNodeById((long)nodeId);
            tx.success();
            Node node = nodeById;
            return node;
        }
    }
}

