/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Arrays;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.string.UTF8;

public class AuthTokenUtil {
    public static boolean matches(Map<String, Object> expected, Object actualObject) {
        if (expected == null || actualObject == null) {
            return expected == actualObject;
        }
        if (!(actualObject instanceof Map)) {
            return false;
        }
        Map actual = (Map)actualObject;
        if (expected.size() != actual.size()) {
            return false;
        }
        for (Map.Entry<String, Object> expectedEntry : expected.entrySet()) {
            String key = expectedEntry.getKey();
            Object expectedValue = expectedEntry.getValue();
            Object actualValue = actual.get(key);
            if (AuthToken.containsSensitiveInformation((String)key)) {
                byte[] expectedByteArray = expectedValue instanceof byte[] ? (byte[])expectedValue : (byte[])(expectedValue != null ? UTF8.encode((String)((String)expectedValue)) : null);
                if (Arrays.equals(expectedByteArray, (byte[])actualValue)) continue;
                return false;
            }
            if (expectedValue == null || actualValue == null) {
                return expectedValue == actualValue;
            }
            if (expectedValue.equals(actualValue)) continue;
            return false;
        }
        return true;
    }

    public static void assertAuthTokenMatches(Map<String, Object> expected, Map<String, Object> actual) {
        Assertions.assertFalse((boolean)(expected == null ^ actual == null));
        Assertions.assertEquals(expected.keySet(), actual.keySet());
        expected.forEach((key, expectedValue) -> {
            Object actualValue = actual.get(key);
            if (AuthToken.containsSensitiveInformation((String)key)) {
                byte[] expectedByteArray = expectedValue != null ? UTF8.encode((String)((String)expectedValue)) : null;
                Assertions.assertArrayEquals((byte[])expectedByteArray, (byte[])((byte[])actualValue));
            } else {
                Assertions.assertEquals((Object)expectedValue, actualValue);
            }
        });
    }
}

