/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.SecurityTestUtils;

class UserTest {
    UserTest() {
    }

    @Test
    void shouldBuildImmutableUser() {
        SystemGraphCredential abc = SecurityTestUtils.credentialFor("123abc");
        SystemGraphCredential fruit = SecurityTestUtils.credentialFor("fruit");
        User u1 = new User.Builder("Steve", (Credential)abc).build();
        User u2 = new User.Builder("Steve", (Credential)fruit).withRequiredPasswordChange(true).withFlag("nice_guy").build();
        Assertions.assertThat((Object)u1).isEqualTo((Object)u1);
        Assertions.assertThat((Object)u1).isNotEqualTo((Object)u2);
        User u1AsU2 = u1.augment().withCredentials((Credential)fruit).withRequiredPasswordChange(true).withFlag("nice_guy").build();
        Assertions.assertThat((Object)u1).isNotEqualTo((Object)u1AsU2);
        Assertions.assertThat((Object)u2).isEqualTo((Object)u1AsU2);
        User u2AsU1 = u2.augment().withCredentials((Credential)abc).withRequiredPasswordChange(false).withoutFlag("nice_guy").build();
        Assertions.assertThat((Object)u2).isNotEqualTo((Object)u2AsU1);
        Assertions.assertThat((Object)u1).isEqualTo((Object)u2AsU1);
        Assertions.assertThat((Object)u1).isNotEqualTo((Object)u2);
    }

    @Test
    void shouldBuildUserWithId() {
        SystemGraphCredential abc = SecurityTestUtils.credentialFor("123abc");
        User u1 = new User.Builder("Alice", (Credential)abc).withId("id1").build();
        User u2 = new User.Builder("Alice", (Credential)abc).withId("id2").build();
        User u3 = new User.Builder("Alice", (Credential)abc).build();
        Assertions.assertThat((Object)u1).isEqualTo((Object)u1);
        Assertions.assertThat((Object)u1).isNotEqualTo((Object)u2);
        Assertions.assertThat((Object)u1).isNotEqualTo((Object)u3);
        Assertions.assertThat((Object)u3).isNotEqualTo((Object)u1);
    }
}

