/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.ShiroAuthToken;
import org.neo4j.test.AuthTokenUtil;

class ShiroAuthTokenTest {
    private static final String USERNAME = "myuser";
    private static final String PASSWORD = "mypw123";

    ShiroAuthTokenTest() {
    }

    @Test
    void shouldSupportBasicAuthToken() throws Exception {
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)USERNAME, (String)PASSWORD));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        Map expected = MapUtil.map((Object[])new Object[]{"principal", USERNAME, "credentials", PASSWORD, "scheme", "basic"});
        ((MapAssert)Assertions.assertThat((Map)token.getAuthTokenMap()).as("Token map should have only expected values", new Object[0])).matches(map -> AuthTokenUtil.matches(expected, map));
        ShiroAuthTokenTest.testTokenSupportsRealm(token, true, "unknown", "native", "ldap");
    }

    @Test
    void shouldSupportBasicAuthTokenWithEmptyRealm() throws Exception {
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)USERNAME, (String)PASSWORD, (String)""));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        Map expected = MapUtil.map((Object[])new Object[]{"principal", USERNAME, "credentials", PASSWORD, "scheme", "basic", "realm", ""});
        ((MapAssert)Assertions.assertThat((Map)token.getAuthTokenMap()).as("Token map should have only expected values", new Object[0])).matches(map -> AuthTokenUtil.matches(expected, map));
        ShiroAuthTokenTest.testTokenSupportsRealm(token, true, "unknown", "native", "ldap");
    }

    @Test
    void shouldSupportBasicAuthTokenWithNullRealm() throws Exception {
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)USERNAME, (String)PASSWORD, null));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        Map expected = MapUtil.map((Object[])new Object[]{"principal", USERNAME, "credentials", PASSWORD, "scheme", "basic", "realm", null});
        ((MapAssert)Assertions.assertThat((Map)token.getAuthTokenMap()).as("Token map should have only expected values", new Object[0])).matches(map -> AuthTokenUtil.matches(expected, map));
        ShiroAuthTokenTest.testTokenSupportsRealm(token, true, "unknown", "native", "ldap");
    }

    @Test
    void shouldSupportBasicAuthTokenWithWildcardRealm() throws Exception {
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)USERNAME, (String)PASSWORD, (String)"*"));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        Map expected = MapUtil.map((Object[])new Object[]{"principal", USERNAME, "credentials", PASSWORD, "scheme", "basic", "realm", "*"});
        ((MapAssert)Assertions.assertThat((Map)token.getAuthTokenMap()).as("Token map should have only expected values", new Object[0])).matches(map -> AuthTokenUtil.matches(expected, map));
        ShiroAuthTokenTest.testTokenSupportsRealm(token, true, "unknown", "native", "ldap");
    }

    @Test
    void shouldSupportBasicAuthTokenWithSpecificRealm() throws Exception {
        String realm = "ldap";
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)USERNAME, (String)PASSWORD, (String)realm));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        Map expected = MapUtil.map((Object[])new Object[]{"principal", USERNAME, "credentials", PASSWORD, "scheme", "basic", "realm", "ldap"});
        ((MapAssert)Assertions.assertThat((Map)token.getAuthTokenMap()).as("Token map should have only expected values", new Object[0])).matches(map -> AuthTokenUtil.matches(expected, map));
        ShiroAuthTokenTest.testTokenSupportsRealm(token, true, realm);
        ShiroAuthTokenTest.testTokenSupportsRealm(token, false, "unknown", "native");
    }

    @Test
    void shouldSupportCustomAuthTokenWithSpecificRealm() throws Exception {
        String realm = "ldap";
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newCustomAuthToken((String)USERNAME, (String)PASSWORD, (String)realm, (String)"basic"));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        Map expected = MapUtil.map((Object[])new Object[]{"principal", USERNAME, "credentials", PASSWORD, "scheme", "basic", "realm", "ldap"});
        ((MapAssert)Assertions.assertThat((Map)token.getAuthTokenMap()).as("Token map should have only expected values", new Object[0])).matches(map -> AuthTokenUtil.matches(expected, map));
        ShiroAuthTokenTest.testTokenSupportsRealm(token, true, realm);
        ShiroAuthTokenTest.testTokenSupportsRealm(token, false, "unknown", "native");
    }

    @Test
    void shouldSupportCustomAuthTokenWithSpecificRealmAndParameters() throws Exception {
        String realm = "ldap";
        Map params = MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"});
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newCustomAuthToken((String)USERNAME, (String)PASSWORD, (String)realm, (String)"basic", (Map)params));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        Map expected = MapUtil.map((Object[])new Object[]{"principal", USERNAME, "credentials", PASSWORD, "scheme", "basic", "realm", "ldap", "parameters", params});
        ((MapAssert)Assertions.assertThat((Map)token.getAuthTokenMap()).as("Token map should have only expected values", new Object[0])).matches(map -> AuthTokenUtil.matches(expected, map));
        ShiroAuthTokenTest.testTokenSupportsRealm(token, true, realm);
        ShiroAuthTokenTest.testTokenSupportsRealm(token, false, "unknown", "native");
    }

    @Test
    void shouldHaveStringRepresentationWithNullRealm() throws Exception {
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)USERNAME, (String)PASSWORD, null));
        ShiroAuthTokenTest.testBasicAuthToken(token, USERNAME, PASSWORD, "basic");
        String stringRepresentation = token.toString();
        Assertions.assertThat((String)stringRepresentation).contains(new CharSequence[]{"realm='null'"});
    }

    private static void testTokenSupportsRealm(ShiroAuthToken token, boolean supports, String ... realms) {
        for (String realm : realms) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)token.supportsRealm(realm)).as("Token should support '" + realm + "' realm", new Object[0])).isEqualTo(supports);
        }
    }

    private static void testBasicAuthToken(ShiroAuthToken token, String username, String password, String scheme) throws InvalidAuthTokenException {
        ((AbstractStringAssert)Assertions.assertThat((String)token.getScheme()).as("Token should have basic scheme", new Object[0])).isEqualTo(scheme);
        ((ObjectAssert)Assertions.assertThat((Object)token.getPrincipal()).as("Token have correct principal", new Object[0])).isEqualTo((Object)username);
        ((ObjectAssert)Assertions.assertThat((Object)token.getCredentials()).as("Token have correct credentials", new Object[0])).isEqualTo((Object)SecurityTestUtils.password(password));
    }
}

