/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.server.security.systemgraph.SystemGraphRealmHelper;
import org.neo4j.time.Clocks;

class SecurityContextDescriptionTest {
    private SecurityContext context;

    SecurityContextDescriptionTest() {
    }

    @BeforeEach
    void setup() throws Throwable {
        SystemGraphRealmHelper realmHelper = (SystemGraphRealmHelper)Mockito.spy((Object)new SystemGraphRealmHelper(null, new SecureHasher()));
        BasicSystemGraphRealm realm = new BasicSystemGraphRealm(realmHelper, (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clocks.systemClock(), Config.defaults()));
        User user = new User.Builder("johan", (Credential)SecurityTestUtils.credentialFor("bar")).withId("id").build();
        ((SystemGraphRealmHelper)Mockito.doReturn((Object)user).when((Object)realmHelper)).getUser("johan");
        this.context = realm.login(SecurityTestUtils.authToken("johan", "bar"), ClientConnectionInfo.EMBEDDED_CONNECTION).authorize(LoginContext.IdLookup.EMPTY, "neo4j", (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
    }

    @Test
    void shouldMakeNiceDescription() {
        Assertions.assertThat((String)this.context.description()).isEqualTo("user 'johan' with FULL");
    }

    @Test
    void shouldMakeNiceDescriptionWithMode() {
        SecurityContext modified = this.context.withMode((AccessMode)AccessMode.Static.WRITE);
        Assertions.assertThat((String)modified.description()).isEqualTo("user 'johan' with WRITE");
    }

    @Test
    void shouldMakeNiceDescriptionRestricted() {
        SecurityContext restricted = this.context.withMode((AccessMode)new RestrictedAccessMode(this.context.mode(), AccessMode.Static.READ));
        Assertions.assertThat((String)restricted.description()).isEqualTo("user 'johan' with FULL restricted to READ");
    }

    @Test
    void shouldMakeNiceDescriptionOverridden() {
        SecurityContext overridden = this.context.withMode((AccessMode)new OverriddenAccessMode(this.context.mode(), AccessMode.Static.READ));
        Assertions.assertThat((String)overridden.description()).isEqualTo("user 'johan' with FULL overridden by READ");
    }

    @Test
    void shouldMakeNiceDescriptionAuthDisabled() {
        SecurityContext disabled = SecurityContext.AUTH_DISABLED;
        Assertions.assertThat((String)disabled.description()).isEqualTo("AUTH_DISABLED with FULL");
    }

    @Test
    void shouldMakeNiceDescriptionAuthDisabledAndRestricted() {
        SecurityContext disabled = SecurityContext.AUTH_DISABLED;
        SecurityContext restricted = disabled.withMode((AccessMode)new RestrictedAccessMode(disabled.mode(), AccessMode.Static.READ));
        Assertions.assertThat((String)restricted.description()).isEqualTo("AUTH_DISABLED with FULL restricted to READ");
    }
}

